const config = {
    // 是，否 number
    YES_NO: [
        { value: 1, label: '是' },
        { value: 0, label: '否' },
    ],
    // 是，否 boolean
    YES_NO_B: [
        { value: true, label: '是' },
        { value: false, label: '否' },
    ],
    // 单位类型
    COMPANY_TYPE: [
        { value: 1, label: '外部单位' },
        { value: 2, label: '内部单位' },
    ],
    // 数据源类型
    DATASOURCE_TYPE: [
        { value: 1, label: '汇聚源' },
        { value: 4, label: '共享源' },
    ],
    // 数据库类型
    DB_TYPE: [
        {
            value: 'Mysql',
        },
        {
            value: 'Oracle',
        },
        {
            value: 'SqlServer',
        },
        {
            value: 'PostgreSql'
        },
    ],
    // 数据库类型
    DB_TYPE_LIST: [
        {
            value: 'Mysql',
            driverName: 'com.mysql.cj.jdbc.Driver',
            url: 'jdbc:mysql://${ip}:${port}/${instance}?useUnicode=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&zeroDateTimeBehavior=convertToNull',
            validationquery: 'select 1 from dual',
        },
        {
            value: 'Oracle',
            driverName: 'oracle.jdbc.OracleDriver',
            url: 'jdbc:oracle:thin:@${ip}:${port}:${instance}',
            validationquery: 'select 1 from dual',
        },
        {
            value: 'SqlServer',
            driverName: 'com.microsoft.sqlserver.jdbc.SQLServerDriver',
            url: 'jdbc:sqlserver://${ip}:${port};databaseName=${instance}',
            validationquery: 'select 1',
        },
        {
            value: 'PostgreSql',
            driverName: 'org.postgresql.Driver',
            url: 'jdbc:postgresql://${ip}:${port}/${instance}',
            validationquery: 'select 1',
        },
    ],
    // 文件提供类型
    DATA_FILE_TYPE: [
        { label: 'xls', value: 'xls' },
        { label: 'cvs', value: 'cvs' },
    ],
    // 密级
    SECRET_LEVEL: [
        { label: '低', value: '1' },
        { label: '中', value: '2' },
        { label: '较高', value: '3' },
        { label: '高', value: '4' },
    ],
    // 数据项提供方式
    SOURCE_PROVIDED_TYPE: [
        { label: '数据库', value: '1' },
        { label: '接口', value: '2' },
        { label: '离线文件', value: '3' },
        { label: '消息中间件', value: '4' },
    ],
    // 资源项格式
    SOURCE_FILE_TYPE: [
        { label: '电子文件', value: '1' },
        { label: '电子表格', value: '2' },
        { label: '数据库', value: '3' },
        { label: '图形/图像', value: '4' },
        { label: '流媒体', value: '5' },
        { label: '其它', value: '6' },
    ],
    // 数据表更新周期
    UPDATE_RATE: [
        { label: '仅一次', value: '1' },
        { label: '实时', value: '2' },
        { label: '每天', value: '3' },
        { label: '每周', value: '4' },
        { label: '每月', value: '5' },
        { label: '每季度', value: '6' },
        { label: '每年', value: '7' },
        { label: '不定期', value: '8' },
    ],
    TABLE_TYPE: [
        { label: '主表', value: '1' },
        { label: '子表', value: '2' },
    ],
};

export default {
    ...config,
    filterDict: (type, val) => {
        return config[type].find((item) => item.value === val);
    },
};
