import api from '@/request'

// 处理图片路径
function getImgPath(imgInfo) {
  if (!imgInfo) return ''
  const {
    0: {id = ''}
  } = JSON.parse(imgInfo) || []
  return `${window.context.portal}/file/onlinePreviewController/v1/getFileById_${id}`
}

export default {
  namespaced: true,
  state: {
    systemInformation: {}
  },
  getters: {
    // 用户端LOGO
    frontLogoPath(state) {
      return getImgPath(state.systemInformation?.frontLogo || '')
    },
    // 页面ICO
    icoPath(state) {
      return getImgPath(state.systemInformation?.ico || '')
    },
    // 管理端LOGO
    manageLogoPath(state) {
      return getImgPath(state.systemInformation?.manageLogo || '')
    }
  },
  actions: {
    //   获取系统信息
    async getSystemInformation({commit}) {
      try {
        const {data} = await api.get(
          '${uc}/uc/tenantManage/v1/getTenantByCode?code=platform'
        )
        commit('SET_SYSTEM_INFORMATION', data)
        return data
      } catch (error) {
        return error
      }
    }
  },
  mutations: {
    // 设置系统信息
    SET_SYSTEM_INFORMATION(state, systemInformation) {
      state.systemInformation = systemInformation
    },

    // 设置项目icon
    SET_FAVICON(state, linkHref = '') {
      let link = document.querySelector("link[rel~='icon']")
      if (!link) {
        link = document.createElement('link')
        link.rel = 'icon'
        document.head.appendChild(link)
      }
      link.href = linkHref
        ? linkHref
        : getImgPath(state.systemInformation?.ico || '') // 动态设置图标路径
    }
  }
}
