export default {
  props: {
    value: {
      type: Boolean,
      default: false,
    },
    data: {
      type: Object,
      default: () => ({}),
    },
    title: {
      type: String,
      default: '',
    },
    confirm: {
      type: Function,
      default: null,
    },
    cancel: {
      type: Function,
      default: null,
    },
  },
  data() {
    return {
      loading: false,
      visible: this.value,
      isFirstLoad: false,
    };
  },
  watch: {
    value(val) {
      this.visible = val;
    },
    async visible(val) {
      if (val) {
        let data = null;
        if (this.data || Array.isArray(this.data)) {
          data = this.data;
        }
        if (!this.isFirstLoad) {
          this.isFirstLoad = true;
          this.firstLoad && typeof this.firstLoad === 'function' && await this.firstLoad();
        }
        this.initData && typeof this.initData === 'function' && this.initData(data);

      }
      this.$emit('input', val);
    },
  },
  methods: {},
};
