import 'babel-polyfill';
import Vue from 'vue';
import App from './App.vue';
import store from './store';
import router from './router/router';
import Print from '@/plugs/print'; // 打印插件 源码修改过 getStyle方法
import ElementUI from 'element-ui';
import i18n from '@/lang/index.js';
import moment from 'moment'; // 日期格式化插件
import VueUeditorWrap from 'vue-ueditor-wrap'; // 引入富文本组件
import HotentUi from 'bpm_el_ui'; // 引入ui
import 'bpm_el_ui/lib/bpm_el_ui.css';
import 'bpm_el_ui/src/assets/css/element-variables.scss';
import '@/assets/css/element-custom.scss';
import '@/directive.js';
import req from '@/request.js';
import deepmerge from 'deepmerge';
import validate from '@/validate.js';
import dict from '@/lang/dict.js';
import HtSubmitButton from '@/components/common/HtSubmitButton.vue';
import HtDeleteButton from '@/components/common/HtDeleteButton.vue';
import ExportData from '@/components/ImportExportData/ExportData/ExportData.vue';
import ImportData from '@/components/ImportExportData/ImportData/ImportData.vue';
import HtLoadData from '@/components/common/HtLoadData.vue';
import AppTable from '@/components/appComponents/AppTable';
import AppTitleBar from '@/components/appComponents/AppTitleBar';
import AppFilter from '@/components/appComponents/AppFilter/index';
import AppFilterPopup from '@/components/appComponents/AppFilter/AppFilterPopup';
import AppFilterItem from '@/components/appComponents/AppFilter/AppFilterItem';
import AppDialog from '@/components/appComponents/AppDialog';
import AppTabs from '@/components/appComponents/AppTabs';
import AppTree from '@/components/appComponents/AppTree/index.vue';
import AppSyncTree from '@/components/appComponents/AppSyncTree';
import AppDrawer from '@/components/appComponents/AppDrawer';

import VueClipboard from 'vue-clipboard2';
import Formulas from '@/formulas.js';
// import VueAMap from 'vue-amap' //高德地图插件
// import AMap from 'vue-amap'
import Viewer from 'v-viewer'; // 图片预览插件
import 'viewerjs/dist/viewer.css';

import Video from 'video.js';
import 'video.js/dist/video-js.css';
import CollapseTransition from 'element-ui/lib/transitions/collapse-transition';
import '@/assets/css/circulate.scss';
// 大屏组件
import dataV from '@jiaminghi/data-view';
// 引入字典
import DictSelect from '@/components/dict/DictSelect.vue';
import dictUtils from '@/components/dict/DictSelectUtils';
// 引入公司选择器
import CompanyInfoSelector from '@/components/selector/companyInfoSelector.vue';
// 引入用户选择器
import CompanyUserSelector from '@/components/selector/companyUserSelector.vue';
// 侧边导航事件
import eventBus from './api/bus.js';
// 菜单图标
import svgIcon from '@/components/global/svgIcon.vue';
// 字符串解析和序列化字符串
import qs from 'qs';

// 获取字典名字
Vue.prototype.getDictName = (dictCode, value) => {
  let name = '';
  const dictItems = dictUtils.getDictItemsFromCache(dictCode);
  dictItems.forEach((item) => {
    if (item.value == value) {
      name = item.name;
    }
  });
  return name;
};
Vue.use(dataV);
// 获取字典数据
Vue.prototype.getDictData = (dictCode) => {
  const arr = [];
  const dictItems = dictUtils.getDictItemsFromCache(dictCode);
  dictItems.forEach((item) => {
    arr.push({
      text: item.name,
      value: item.value,
    });
  });
  return arr;
};

Vue.prototype.getDictDataSearch = (dictCode) => {
  const arr = [];
  const dictItems = dictUtils.getDictItemsFromCache(dictCode);
  dictItems.forEach((item) => {
    arr.push({
      value: item.name,
      key: item.value,
    });
  });
  return arr;
};
Vue.prototype.getDate = () => {
  const nowDate = new Date();
  let date = {
    year: nowDate.getFullYear(),
    month: nowDate.getMonth() + 1,
    date: nowDate.getDate(),
  };
  const newmonth = date.month > 10 ? date.month : `0${date.month}`;
  const day = date.date > 10 ? date.date : `0${date.date}`;
  date = `${date.year}-${newmonth}-${day}`;
  return date;
};

Vue.use(eventBus);

Vue.prototype.$video = Video;

Vue.config.debug = true;

Vue.prototype.$http = req;

/* Vue.use(AMap)
AMap.initAMapApiLoader({
  // key: 'babe07289a50fc3eda093e6ccea2f8a4',
  key: '7d54f1d3d43901f3c6a728971dd4a9c2', //中铁建亿联-web端	 key值：7d54f1d3d43901f3c6a728971dd4a9c2
  // 可使用服务： JavaScript API  地图组件室内地图  JS API地铁图  JS API
  plugin: [
    'AMap.Autocomplete',
    'AMap.PlaceSearch',
    'AMap.Scale',
    'AMap.OverView',
    'AMap.ToolBar',
    'AMap.MapType',
    'AMap.PolyEditor',
    'AMap.CircleEditor',
    'AMap.Geolocation',
    'AMap.Driving',
    'AMap.Geocoder',
    'AMap.service',
    'AMap.convertFrom',
    'AMap.RoadInfoSearch',
    'Map3D',
    'AMap.DistrictSearch',
    'AMap.Polyline'
  ],
  // 默认高德 sdk 版本为 1.4.4
  v: '1.4.4'
})*/

Vue.prototype.qs = qs;

Vue.use(Viewer, {
  defaultOptions: {
    zIndex: 9999,
    toolbar: true,
  },
});
Vue.use(VueClipboard);
Vue.use(ElementUI, {
  i18n: (key, value) => i18n.t(key, value),
  size: 'small',
});

Vue.use(HotentUi, {
  i18n: (key, value) => i18n.t(key, value),
});

Vue.use(Print);
Vue.use(Formulas);

// 注册全局组件
// Vue.use(VueAMap)
Vue.component('svgIcon', svgIcon);
Vue.component('HtSubmitButton', HtSubmitButton);
Vue.component('HtDeleteButton', HtDeleteButton);
Vue.component('DictSelect', DictSelect);
Vue.component('CompanyInfoSelector', CompanyInfoSelector);
Vue.component('CompanyUserSelector', CompanyUserSelector);
Vue.component('HtLoadData', HtLoadData);
Vue.component('AppTable', AppTable);
Vue.component('AppTitleBar', AppTitleBar);
Vue.component('AppFilter', AppFilter);
Vue.component('AppFilterPopup', AppFilterPopup);
Vue.component('AppFilterItem', AppFilterItem);
Vue.component('AppDialog', AppDialog);
Vue.component('AppTabs', AppTabs);
Vue.component('AppTree', AppTree);
Vue.component('AppSyncTree', AppSyncTree);
Vue.component('AppDrawer', AppDrawer);

Vue.filter('formatDate', function (value, pattern = 'YYYY-MM-DD HH:mm:ss') {
  if (!value) {
    return '';
  }
  return moment(value).format(pattern);
});
Vue.component('vue-ueditor-wrap', VueUeditorWrap);
Vue.component(CollapseTransition.name, CollapseTransition);
Vue.component('ExportData', ExportData);
Vue.component('ImportData', ImportData);
// Vue.prototype.$echarts = echarts

window.app = new Vue({
  store,
  router,
  i18n,
  render: function (createElement) {
    if ('-ms-scroll-limit' in document.documentElement.style && '-ms-ime-align' in document.documentElement.style) {
      window.addEventListener(
        'hashchange',
        () => {
          var currentPath = window.location.hash.slice(1);
          if (this.$route.path !== currentPath) {
            this.$router.push(currentPath);
          }
        },
        false,
      );
    }
    return createElement(App);
  },
}).$mount('#root');

const validateLocal = localStorage.getItem('lang');
const currentLocal = validateLocal || 'zh-CN';
app.$validator.locale = currentLocal;

if (app.$validator) {
  for (const rule in validate) {
    app.$validator.rules[rule] = validate[rule];
  }
  app.$validator.dictionary.container = deepmerge(dict, app.$validator.dictionary.container, { clone: true });
}

// 日期控件格式化
if (currentLocal == 'zh-CN') {
  moment.locale('zh-cn');
} else {
  moment.locale('en');
}

// el-tooltip 默认显示
Vue.prototype.$tooltipplacement = 'bottom';
export default app;
