import req from '@/request.js';

const portal = window.context.portal;
export default {
  // 分页查询-列表
  demandSideTable(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareConsumer/v1/query`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 新增
  demandSideAdd(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareConsumer/v1/registerShareConsumer`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 修改
  demandSideEdit(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataShare/shareConsumer/v1/updateInfo`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 批量删除
  deleteTableData(data) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/dataShare/shareConsumer/v1/?ids=${data}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 单个删除
  removeShare(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/dataShare/shareConsumer/v1/${id}`).then(
        (res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },

  // 验证账户
  checkDataUserIsExist(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareConsumer/v1/checkDataUserIsExist`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 查询详情
  getCompanyDetail(id) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareConsumer/v1/getInfoById?id=${id}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 授权-库表资源-列表
  detaBaseResourceAuthorization(data, id) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTable/v1/queryAuthPage?consumerId=${id}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },
  // 授权-文件资源-列表
  fileResourceAuthorization(data, id, treeId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareFiles/v1/queryPageByCatalog?consumerId=${id}&catalogId=${treeId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },
  // 授权-接口资源-列表
  apiResourceAuthorization(data, id, treeId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareApi/v1/queryPageByCatalog?consumerId=${id}&catalogId=${treeId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 授权资源
  authorizationConfirm(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dateShare/shareAuth/v1/auth`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 删除资源
  authorizationDelete(delId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dateShare/shareAuth/v1/revokeAuth?ids=${delId}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 授权资源之后的列表
  // grantColumnList(data, consumerId, resourceType) {
  //   return new Promise((resolve, reject) => {
  //     req.post(`${portal}/biz/dateShare/shareAuth/v1/queryPageByConsumer?consumerId=${consumerId}&resourceType=${resourceType}`, data).then(
  //       response => {
  //         resolve(response.data);
  //       },
  //       error => {
  //         reject(error);
  //       }
  //     );
  //   });
  // },

  // 授权资源之后的列表 - 数据库
  authorizationDatabase(data, consumerId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dateShare/shareAuth/v1/queryTableAuth?consumerId=${consumerId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 授权资源之后的列表 - 文件
  authorizationFile(data, consumerId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dateShare/shareAuth/v1/queryFilesAuth?consumerId=${consumerId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 授权资源之后的列表 - 接口
  authorizationApi(data, consumerId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dateShare/shareAuth/v1/queryApiAuth?consumerId=${consumerId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 资源编目 授权资源之后的列表 - 数据库
  resourceInventoryDatabase(data, tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareConsumer/v1/queryAuthByTable?tableId=${tableId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 资源编目 授权资源之后的列表 - 文件
  resourceInventoryFile(data, tableId, resourceId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareConsumer/v1/queryAuthByFiles?tableId=${tableId}&resourceId=${resourceId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 资源编目 授权资源之后的列表 - 接口
  resourceInventoryApi(data, tableId, resourceId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareConsumer/v1/queryAuthByApi?tableId=${tableId}&resourceId=${resourceId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  databaseBefore(data, tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareConsumer/v1/queryUnAuthByTable?tableId=${tableId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  fileBefore(data, tableId, resourceId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareConsumer/v1/queryUnAuthByFiles?tableId=${tableId}&resourceId=${resourceId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  apiBefore(data, tableId, resourceId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareConsumer/v1/queryUnAuthByTable?tableId=${tableId}&resourceId=${resourceId}`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

};
