import req from '@/request.js';

const portal = window.context.portal;

const headersUrlencoded = {
  'Content-type': 'application/x-www-form-urlencoded'
}

export default {
  // 获取枚举字典目录
  getEnumDictTree(data) {
    return new Promise((resolve, reject) => {
      req
        .get(`${portal}/sys/sysType/v1/getTypesByKey?typeKey=SYS_DICT`)
        .then((res) => resolve(res.data || []))
        .catch((err) => reject(err));
    });
  },
  // 保存枚举字典目录
  saveEnumDictDir(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/sys/sysType/v1/save?parentId=${data.parentId}&isRoot=${data.parentId == 0 ? 1 : 0}&isPriNode=0&isDefaultAuth=0`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    })
  },
  // 删除枚举字典目录
  deleteEnumDictDir(id) {
    return new Promise((resolve, reject) => {
      req
        .remove(`${portal}/sys/sysType/v1/remove?id=${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 查询枚举字典
  getEnumDict(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/sys/sysDictionary/v1/query`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 同步缓存
  syncDictionaryRedis() {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/sys/sysDictionary/v1/syncDictionaryRedis`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },

  // 启用禁用字典
  updateDictionariesStatus(param) {
    let data = {
      url: portal + `/sys/sysDictionary/v1/updateDictionariesStatus`,
      data: param,
      method: "post",
      headers: headersUrlencoded
    }
    return new Promise((resolve, reject) => {
      req.request(data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },

  // 删除字典
  deleteEnumDict(param) {
    let data = {
      url: portal + `/sys/sysDictionary/v1/deleteDictionaries`,
      data: param,
      method: "post",
      headers: headersUrlencoded
    }
    return new Promise((resolve, reject) => {
      req.request(data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },

  // 保存枚举字典
  saveEnumDict(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/sys/sysDictionary/v1/saveDictionary`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },

  // loadDictionaryById
  loadDictionaryById(params) {
    let data = {
      url: portal + `/sys/sysDictionary/v1/loadDictionaryById`,
      data: params,
      method: "post",
      headers: headersUrlencoded
    }
    return new Promise((resolve, reject) => {
      req.request(data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },

  updateDictItemStatus(param) {
    let data = {
      url: portal + `/sys/sysDictionaryDetail/v1/updateDictionariesDetailsStatus`,
      data: param,
      method: "post",
      headers: headersUrlencoded
    }
    return new Promise((resolve, reject) => {
      req.request(data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  
  updateDictItemSequence(param) {
    let url = portal + `/sys/sysDictionaryDetail/v1/updateDictionariesDetailsSequence`
    return new Promise((resolve, reject) => {
      req.post(url, param)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },

  deleteDictItem(param) {
    let data = {
      url: portal + `/sys/sysDictionaryDetail/v1/deleteDictionaryDetails`,
      data: param,
      method: "post",
      headers: headersUrlencoded
    }
    return new Promise((resolve, reject) => {
      req.request(data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },

  // 多维字典树
  getMultiDictTree(data) {
    return new Promise((resolve, reject) => {
      req
        .get(`${portal}/sys/sysType/v1/getByParentId?catId=5`)
        .then((res) => resolve(res.data || []))
        .catch((err) => reject(err));
    });
  },
  // 多维字典列表
  getMultiDict(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/sys/dataDict/v1/listJson`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 新增多维字典目录
  saveMultiDirNode(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/sys/sysType/v1/save?parentId=${data.parentId}&isRoot=0&isPriNode=0`, data.sysType)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 删除多维字典目录
  removeMultiDirNode(data) {
    return new Promise((resolve, reject) => {
      req
        .get(`${portal}/sys/dataDict/v1/removeByTypeId?typeIds=${data.id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 多维字典批量保存
  saveMultiDictItemBatch(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/sys/dataDict/v1/saveAndUpdateValBatch`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 多维字典保存
  saveMultiDictItem(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/sys/dataDict/v1/saveAndUpdate`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 多维字典树
  queryDictTree(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/sys/dataDict/v1/getDicByDicId`, data.id)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
  // 删除多维字典项/字段值
  removeDictNode(id) {
    return new Promise((resolve, reject) => {
      req
        .remove(`${portal}/sys/dataDict/v1/remove?id=${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err));
    });
  },
};
