import req from '@/request.js';

const bpmModel = window.context.bpmModel;
const bpmRunTime = window.context.bpmRunTime;
const portal = window.context.portal;
export default {
  getList(type) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/datasourcesRelation/v1/queryList/${type}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
  // 测试数据源连接
  checkConnection(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/sys/sysDataSource/v1/checkConnection`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
  // 保存数据源
  saveSource(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/datasourcesRelation/v1/save`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
  delSource(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/datasourcesRelation/v1/${id}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
};
