[目录](index.md)

* [基本用法 *](1.usage.md)
* [选项](2.options.md)
* [界面操控](3.operation.md)
* [实验性功能](experimental-features.md)
  * [截图 (导出图片)](plugin-screenshot.md)
* [参与贡献](4.contribution.md)
* [贡献代码指南](5.development.md)

1.1. 基本框架
===

首先，需要在页面上引用 jsmind.js 和 jsmind.css 两个文件，这里我们引用的是 CDN 上的资源，请注意使用最新的版本。


```html
<link type="text/css" rel="stylesheet" href="https://unpkg.com/jsmind@0.8.6/style/jsmind.css" />

<script type="text/javascript" src="https://unpkg.com/jsmind@0.8.6/es6/jsmind.js"></script>
```

> 常用的 CDN 有 [UNPKG](https://unpkg.com/jsmind/)，[jsDelivr](https://www.jsdelivr.com/package/npm/jsmind/)，以及 jsDelivr 的[国内镜像](https://jsd.onmicrosoft.cn/npm/jsmind/)。文件路径大概像这样：
> - https://unpkg.com/jsmind@0.8.6/es6/jsmind.js
> - https://cdn.jsdelivr.net/npm/jsmind@0.8.6/es6/jsmind.js
> - https://jsd.onmicrosoft.cn/npm/jsmind@0.8.6/es6/jsmind.js
>
> 示例中url中都有版本号，强烈建议你在项目里也指明版本号，以避免版本升级给你的项目带来风险。访问 [NPM 上的 jsMind](https://www.npmjs.com/package/jsmind) 可以获取 jsmind 的最新版本号。

如果希望能够通过鼠标拖拽的方式移动节点，需要额外引用 jsmind.draggable-node.js 文件

```html
<script type="text/javascript" src="https://unpkg.com/jsmind@0.8.6/es6/jsmind.draggable-node.js"></script>
```

其次，要为 jsMind 准备一个容器，jsMind 将在这个容器里显示思维导图。可自行定义容器的id、大小及样式。

```html
<div id="jsmind_container"></div>
```

最后，添加下面一段代码即可显示一个空白的思维导图：

```html
<script type="text/javascript">
    var options = {                   // options 将在下一章中详细介绍
        container:'jsmind_container', // [必选] 容器的ID，或者为容器的对象
        editable:true,                // [可选] 是否启用编辑
        theme:'orange'                // [可选] 主题
    };
    var jm = new jsMind(options);
    jm.show();
</script>
```

或者，使用下面的代码显示一个包含既定内容的思维导图：

```html
<script type="text/javascript">
    var mind = { /* jsMind 数据，详见下一节的说明 */ };
    var options = {
        container:'jsmind_container',
        editable:true,
        theme:'orange'
    };

    var jm = new jsMind(options);
    // 让 jm 显示这个 mind 即可
    jm.show(mind); 
</script>
```

1.2. 数据格式
===

jsMind 支持三种数据格式，分别是 `node_tree`、`node_array` 和 `freemind` 格式。jsMind 可以加载其中任一种格式，也能将数据导出为任一种格式。

下面是三种数据格式的简单示例：

A. `node_tree` 格式，jsMind 的默认数据格式
---

```javascript
var mind = {
    /* 元数据，定义思维导图的名称、作者、版本等信息 */
    "meta":{
        "name":"jsMind-demo-tree",
        "author":"hizzgdev@163.com",
        "version":"0.2"
    },
    /* 数据格式声明 */
    "format":"node_tree",
    /* 数据内容 */
    "data":{"id":"root","topic":"jsMind","children":[
        {"id":"easy","topic":"Easy","direction":"left","expanded":false,"children":[
            {"id":"easy1","topic":"Easy to show"},
            {"id":"easy2","topic":"Easy to edit"},
            {"id":"easy3","topic":"Easy to store"},
            {"id":"easy4","topic":"Easy to embed"}
        ]},
        {"id":"open","topic":"Open Source","direction":"right","expanded":true,"children":[
            {"id":"open1","topic":"on GitHub"},
            {"id":"open2","topic":"BSD License"}
        ]},
        {"id":"powerful","topic":"Powerful","direction":"right","children":[
            {"id":"powerful1","topic":"Base on Javascript"},
            {"id":"powerful2","topic":"Base on HTML5"},
            {"id":"powerful3","topic":"Depends on you"}
        ]},
        {"id":"other","topic":"test node","direction":"left","children":[
            {"id":"other1","topic":"I'm from local variable"},
            {"id":"other2","topic":"I can do everything"}
        ]}
    ]}
};
```

B. `node_array` 格式
---

```javascript
var mind = {
    /* 元数据，定义思维导图的名称、作者、版本等信息 */
    "meta":{
        "name":"example",
        "author":"hizzgdev@163.com",
        "version":"0.2"
    },
    /* 数据格式声明 */
    "format":"node_array",
    /* 数据内容 */
    "data":[
        {"id":"root", "isroot":true, "topic":"jsMind"},

        {"id":"easy", "parentid":"root", "topic":"Easy", "direction":"left"},
        {"id":"easy1", "parentid":"easy", "topic":"Easy to show"},
        {"id":"easy2", "parentid":"easy", "topic":"Easy to edit"},
        {"id":"easy3", "parentid":"easy", "topic":"Easy to store"},
        {"id":"easy4", "parentid":"easy", "topic":"Easy to embed"},

        {"id":"open", "parentid":"root", "topic":"Open Source", "expanded":false, "direction":"right"},
        {"id":"open1", "parentid":"open", "topic":"on GitHub"},
        {"id":"open2", "parentid":"open", "topic":"BSD License"},

        {"id":"powerful", "parentid":"root", "topic":"Powerful", "direction":"right"},
        {"id":"powerful1", "parentid":"powerful", "topic":"Base on Javascript"},
        {"id":"powerful2", "parentid":"powerful", "topic":"Base on HTML5"},
        {"id":"powerful3", "parentid":"powerful", "topic":"Depends on you"},
    ]
};
```

C. `freemind` 格式
---

```javascript
var mind = {
    /* 元数据，定义思维导图的名称、作者、版本等信息 */
    "meta":{
        "name":"example",
        "author":"hizzgdev@163.com",
        "version":"0.2"
    },
    /* 数据格式声明 */
    "format":"freemind",
    /* 数据内容 */
    "data":"<map version=\"1.0.1\"> <node ID=\"root\" TEXT=\"jsMind\" > <node ID=\"easy\" POSITION=\"left\" TEXT=\"Easy\" > <node ID=\"easy1\" TEXT=\"Easy to show\" /> <node ID=\"easy2\" TEXT=\"Easy to edit\" /> <node ID=\"easy3\" TEXT=\"Easy to store\" /> <node ID=\"easy4\" TEXT=\"Easy to embed\" /> </node> <node ID=\"open\" POSITION=\"right\" TEXT=\"Open Source\" > <node ID=\"open1\" TEXT=\"on GitHub\" /> <node ID=\"open2\" TEXT=\"BSD License\" /> </node> <node ID=\"powerful\" POSITION=\"right\" TEXT=\"Powerful\" > <node ID=\"powerful1\" TEXT=\"Base on Javascript\" /> <node ID=\"powerful2\" TEXT=\"Base on HTML5\" /> <node ID=\"powerful3\" TEXT=\"Depends on you\" /> </node> <node ID=\"other\" POSITION=\"left\" TEXT=\"test node\" > <node ID=\"other1\" TEXT=\"I'm from local variable\" /> <node ID=\"other2\" TEXT=\"I can do everything\" /> </node> </node> </map>"
};
```

注
---

除 freemind 格式外，其余两种格式的基本数据结构如下：

```javascript

    {
        "id":"open",           // [必选] ID, 所有节点的ID不应有重复，否则ID重复的结节将被忽略
        "topic":"Open Source", // [必选] 节点上显示的内容
        "direction":"right",   // [可选] 节点的方向，此数据仅在第一层节点上有效，目前仅支持 left 和 right 两种，默认为 right
        "expanded":true,       // [可选] 该节点是否是展开状态，默认为 true
    }

```

1.3. 主题
===

jsMind 默认提供了 15 种主题，你可以访问[功能示例](http://hizzgdev.github.io/jsmind/example/2_features.html)页面浏览这些主题。

* primary
* warning
* danger
* success
* info
* greensea
* nephrite
* belizehole
* wisteria
* asphalt
* orange
* pumpkin
* pomegranate
* clouds
* asbestos

当然，你也可以添加自己的主题。只需在 jsmind.css 中按照以下格式添加样式定义即可：

```css
/* greensea theme */                                                      /* greensea 即是主题名 */
jmnodes.theme-greensea jmnode{background-color:#1abc9c;color:#fff;}       /* 节点样式 */
jmnodes.theme-greensea jmnode:hover{background-color:#16a085;}            /* 鼠标悬停的节点样式 */
jmnodes.theme-greensea jmnode.selected{background-color:#11f;color:#fff;} /* 选中的节点样式 */
jmnodes.theme-greensea jmnode.root{}                                      /* 根节点样式 */
jmnodes.theme-greensea jmexpander{}                                       /* 展开/关闭节点的控制点样式 */
jmnodes.theme-greensea jmexpander:hover{}                                 /* 鼠标悬停展开/关闭节点的控制点样式 */
```

1.4. 样式
===

除了上述主题外，你还可以为每一个节点设置单独的样式，目前 jsMind 支持以下自定义样式：

* background-color: 节点的背景颜色，如 `#1abc9c`, `blue`
* foreground-color: 节点的文本颜色，如 `#1abc9c`, `blue`
* width: 节点的宽度(px)，如 `400`
* height: 节点的高度(px)，如 `400`
* font-size: 节点的文本字体大小(px)，如 `32`
* font-weight: 节点的文本重量，如 `bold`
* font-style: 节点的文本样式，如 `italic`
* background-image: 节点的背景图片，可使用 url，如 `http://fakeurl.com/fake-picture.png`，或 data url 形式，如 `data:image/png;base64,...`
* background-rotation: 节点的背景图片旋转角度，如 `30`
* leading-line-color: 节点的引导线颜色，如 `#1abc9c`, `blue`。

设置方法：

* 通过 API 配置：在 data 参数里添加上述配置即可，api 定义见 [[3.4. 界面操控 - 添加节点](3.operation.md)]
 

```javascript
let data = {'width': 400, 'leading-line-color': '#33ff33'}
jm.add_node(....., data)
```

* 在数据定义(数据文件)中配置：把上述参数添加到 `node` 的定义中即可，如：

```javascript

var mind = {
    ...
    format: 'node_tree',
    data: {
        id: 'root',
        topic: 'jsMind',
        children: [
        {
            'id': 'image-node',
            'background-image': 'ant.png',
            'width': '100',
            'height': '100',
        }
    ],
    ...
}
```

版权声明
===

禁止转载、禁止演绎。

jsMind 项目仍在不断升级变化，版本更新时会同时更新对应的文档。为避免给使用者带来困惑，在没有得到书面许可前，禁止转载本文档，同时禁止对本文档进行任何形式的更改。
