[Table of Contents](index.md)

* [Usage](1.usage.md)
* [Options](2.options.md)
* [Operation *](3.operation.md)
* [Experimental Features](experimental-features.md)
  * [Screenshot (Export as Image)](plugin-screenshot.md)
* [Contribution](4.contribution.md)
* [Development Guide](5.development.md)


jsMind object
===

jsMind provides a set of APIs for manipulating the mindmap, all of which are based on the `jsMind` object processing, which can be obtained using the following code.

```javascript
/*
Method 1.
    jsMind objects are available when you create a mindmap
*/
var jm = new jsMind(options);

/*
Method 2.
    This jsMind object can be obtained directly if a mindmap already exists on the current page
    When multiple jsMind are created on a page, this method gets the last object created
*/
var jm = jsMind.current;
```

Node object
===

A mindmap diagram is composed of multiple nodes and connections between nodes, a mindmap diagram has a root node, the root node can have multiple child nodes on the periphery, and the child node can have multiple child nodes. Each node contains more than one of the following attributes.

```javascript
node {
    id,         // : string node id
    index,      // : integer node number
    topic,      // : string node topic
    isroot,     // : boolean indicates whether this node is root or not
    parent,     // : node The parent of this node, the parent program of the root node is null, but please do not judge whether this node is the root node based on this property.
    direction,  // : enum(left,center,right) The distribution position of the node
    children,   // : array of node The combination of children of the node
    expanded,   // : boolean Is the next level of the node expanded or not
    data,       // : object{string: object} Other additional data for this node
}
```

3.1 Displaying a mindmap
===

Use the `jm.show(mind)` method to display a mindmap, see [1.1. Basic framework](1.usage.md) for specific usage.

3.2. Finding Nodes
===

**Get root** : Use `jm.get_root()` to get the root of the current mindmap.

**Find node by id** : Use the `jm.get_node(node_id)` method to find the node specified in the current mind map by id, and return `null` if it is not found.

**Get selected node** : Use `jm.get_selected_node()` to get the currently selected node and return `null` if there is no selected node.

**Find adjacent nodes** : Use `jm.find_node_before(node|node_id)` and `find_node_after(node|node_id)` to get the previous or next node of the specified node, and return `null` if there is no previous or next one.

**Fetch parent** : Use `node.parent` to get the parent node, the parent of the root node is `null`.

**Fetching a collection of child nodes** : A collection of child nodes can be obtained using `node.children`.

3.3 Operation on Nodes
===

**Select node** : Use the `jm.select_node(node)` method to select the specified node.
- `node`: it is the target node to be selected, the parameter value can be either a `node` object or the id of the `node`;

**Collapse child nodes** : Use the `jm.collapse_node(node)` method to collapse the child nodes of the node.
- `node`: it is the target node to be collapsed, the parameter value can be either a `node` object or the id of the `node`;

**Expand Child Node** : Use the `jm.expand_node(node)` method to expand the child node of this node.
- `node`: it is the target node to be expanded, the parameter value can be either a `node` object or the id of the `node`;

**Collapse or expand child nodes** : Use the `jm.toggle_node(node)` method to automatically expand or collapse child nodes.
- `node`: it is the target node to be collapsed or expanded, the parameter value can be either a `node` object or the id of the `node`;

**Expand all child nodes** : All child nodes can be expanded using the `jm.expand_all()` method.

**Expand to level** : Use the `jm.expand_to_depth(depth)` method to expand to a specified level.

**Move Node** : Use the `jm.move_node(node, before_id, parent_id, direction)` method to move a node
- `node`: it is the target node to be moved, the parameter value can be either a `node` object or the id of the `node`;
- `before_id`: it is the id of the destined node, the target node will be moved before the destined node. In addition, 2 values can be used for the parameter:
    - `_first_` the target node will be moved to the first place of all sibling nodes
    - `_last_`  the target node will be moved to the last place of all sibling nodes
- `parent_id`: [Optional] it is the id of the parent node of the destined node. If the parameter is not provided, the id of the parent node of the `before` node will be taken.
- `direction`: [Optional] it is used for moving the level-2 nodes(the direct children of the root node). the node can be moved to the left side or right side. If the node being moved is not a level-2 node, this parameter has no effect; If this parameter is not provided, the direction will be automatically determined. Only 2 values are valid for the parameter:
    - `left`
    - `right`

**center node** : Use the `jm.scroll_node_to_center(node)` method to scroll a node to the center of mindmap. (since 0.6.2)

**Enable editing** : Use the `jm.enable_edit()` method to enable editing of the current mindmap.

**Disable_edit** : Use the `jm.disable_edit()` method to disable editing of the current mindmap.

**Edit Node** : The node can be adjusted to edit using the `jm.begin_edit(node|node_id)` method.
- `node`: it is the target node to be edited, the parameter value can be either a `node` object or the id of the `node`;

**Stop editing** : The node can be adjusted to read-only using the `jm.end_edit()` method.


3.4. Editing Nodes
===

**Add Node** : Use the `jm.add_node(parent_node, node_id, topic, data, direction)` method to add a sub node to the `parent_node`. `data` and `direction` are optional.

**Insert node before specified location** : Use the `jm.insert_node_before(node_before, node_id, topic, data, direction)` method to insert a node before the `node_before` node. `data` and `direction` are optional.

**Insert node after specified location** : Use the `jm.insert_node_after(node_after, node_id, topic, data, direction)` method to insert a node after the `node_after` node. `data` and `direction` are optional.

**Delete Node** : Use the `jm.remove_node(node|node_id)` method to delete a specified node and all its children.

**Update node** : Use the `jm.update_node(node_id, topic)` method to update the topic of the specified node.


3.5 Setting Style
===

**Set the theme** : Use the `jm.set_theme(theme)` method to set the theme of the mind map.

**Set background / foreground color** : Use the `jm.set_node_color(node_id, bg_color, fg_color)` method to set the background and foreground color of the specified node.

**Set Font** : Use the `jm.set_node_font_style(node_id, size, weight, style)` method to set the font of the specified node.

**Set background image** : Use the `jm.set_node_background_image(node_id, image, width, height)` method to set the background image of the specified node.

3.6 Access to Data
===

**Get metadata** : Use the `jm.get_meta()` method to get metadata for the current mindmap.

**Get Data** : Use the `jm.get_data(data_format)` method to get the data text in the specified format of the current mindmap.

3.7 Other Operations
===

**Clear selection of nodes** : Use the `jm.select_clear()` method to clear the current selected state.

**Determine if the node is visible** : Use the `jm.is_node_visible(node)` method to determine if this node is visible.

copyright notice
===

Reproduction and deduction are prohibited.

The jsMind project is still being updated and the corresponding documentation is updated at the same time as the version is updated. In order to avoid confusion to the user, it is forbidden to reprint this document without written permission and to make changes of any kind to this document.
