import req from "@/request.js";

const portal = window.context.portal;
export default {
    //分页
    dataQuery(data, cb) {
        req.post(portal + `/base/square/location/query`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 新增
    addSave(data, cb) {
        req.post(portal + `/base/square/location/`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 修改
    detailId(id, cb) {
        req.get(portal + `/base/square/location/${id}`).then(rep => {
            cb(rep.data);
        });
    },
    // 确认修改
    upData(data, cb) {
        req.put(portal + `/base/square/location/`, data).then(rep => {
            cb(rep.data);
        });
    },
    //删除
    remove(id, cb) {
        req.remove(portal + `/base/square/location/${id}`).then(rep => {
            cb(rep.data);
        });
    },
    //噪音分类树
    getNoise(data, cb) {
        req.post(portal + `/base/noise/level/getTree`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 根据广场舞地点id查询对应名称
    getPlaceName(id) {
        return new Promise((resolve, reject) => {
            req.get(portal + '/base/square/location/' + id).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                });
        })
    }
}