import req from "@/request.js";

const portal = window.context.portal;
export default {
	//分页
	dataQuery(data, cb) {
		req.post(portal + `/base/event/center/endEventQuery`, data).then(rep => {
			cb(rep.data);
		});
	},
	//详情
	detailId(id, cb) {
		req.get(portal + `/base/event/center/processDetailList/${id}`).then(rep => {
			cb(rep.data);
		});
	},
	//流程明细
	taskList(id, cb) {
		req.get(portal + `/base/event/center/taskList/${id}`).then(rep => {
			cb(rep.data);
		});
	},
	//获取文件详情
	fileDetail(id, cb) {
		req.get(portal + `/file/v1/${id}`).then(rep => {
			cb(rep.data);
		});
	},
	//行政区域
	getbaseAreaTree(data, cb) {
		req.post(portal + `/sys/sysAreas/v1/tree`).then(rep => {
			cb(rep.data);
		});
	},
	//归档部门
	orgTreeList(data, cb) {
		req.get(portal + `/api/org/v1/orgTreeList`).then(rep => {
			cb(rep.data);
		});
	},
	//办结归档
	archiving(data, cb) {
		req.post(portal + `/base/event/archiving/`,data).then(rep => {
			cb(rep.data);
		});
	},
	//转存续事件
	survivingOp(data, cb) {
		req.post(portal + `/base/event/archiving/survivingOp`,data).then(rep => {
			cb(rep.data);
		});
	},
	// 更新数据
	archivingUpdate(data, cb) {
		req.put(portal + `/base/event/archiving/`,data).then(rep => {
			cb(rep.data);
		});
	},
	//纳入高频地点
	address(data, cb) {
		req.post(portal + `/base/high/address/`,data).then(rep => {
			cb(rep.data);
		});
	},
	//纳入黑名单
	eventBlack(data, cb) {
		req.post(portal + `/base/event/black/`,data).then(rep => {
			cb(rep.data);
		});
	},
	
	// //处置事件
	// processEvent(data, cb) {
	// 	req.post(portal + `/base/event/center/processEvent`, data).then(rep => {
	// 		cb(rep.data);
	// 	});
	// },

	// //获取组织树
	// orgTree(cb) {
	// 	req.get(portal + `/api/org/v1/orgTree?demId=1491618454686535680`).then(rep => {
	// 		cb(rep.data);
	// 	});
	// },
	// //获取用户
	// orgUserQuery(data, cb) {
	// 	req.post(portal + `/api/user/v1/users/getOrgUserQuery`, data).then(rep => {
	// 		cb(rep.data);
	// 	});
	// },



}