import req from "@/request.js";

const portal = window.context.portal;
export default {
    //分页
    highFrequencyQuery(data, cb) {
        req.post(portal + `/base/high/address/query`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 删除
    highFrequencyDelete(ids,cb){
        req.remove(portal + `/base/high/address/?ids=${ids}`).then(rep => {
            cb(rep.data);
        });
    },
    // 根据id查询实体
    highFrequencyById(id,cb){
        req.get(portal + `/base/high/address/${id}`).then(rep => {
            cb(rep.data);
        });
    },
    // 更新实体
    highFrequencyUpload(data,cb){
        req.put(portal + `/base/high/address/`,data).then(rep => {
            cb(rep.data);
        });
    },
    // 新增实体
    highFrequencyAdd(data,cb){
        req.post(portal + `/base/high/address/`,data).then(rep => {
            cb(rep.data);
        });
    },
    // 获取未纳入高频地点分页结果
    highFrequencyFindNoHigh(data,cb){
        req.post(portal + `/base/square/location/findNoHighByPage`,data).then(rep => {
            cb(rep.data);
        });
    },
}