import Vue from 'vue'

// v-dialogDrag: 弹窗拖拽属性
Vue.directive('dialogDrag', {
    bind(el, binding, vnode, oldVnode) {
        const dialogHeaderEl = el.querySelector('.el-dialog__header')
        const dragDom = el.querySelector('.el-dialog')
        dialogHeaderEl.style.cssText += ';cursor:move;'
        dragDom.style.cssText += ';top:0px;'

        // 获取原有属性
        const getStyle = (function () {
            if (window.document.currentStyle) {
                return (dom, attr) => dom.currentStyle[attr]
            } else {
                return (dom, attr) => getComputedStyle(dom, false)[attr]
            }
        })()

        dialogHeaderEl.onmousedown = (e) => {
            // 鼠标按下，计算当前元素距离可视区的距离
            const disX = e.clientX - dialogHeaderEl.offsetLeft
            const disY = e.clientY - dialogHeaderEl.offsetTop

            const dragDomWidth = dragDom.offsetWidth
            const dragDomheight = dragDom.offsetHeight

            const screenWidth = document.body.clientWidth
            const screenHeight = document.body.clientHeight

            const minDragDomLeft = dragDom.offsetLeft
            const maxDragDomLeft = screenWidth - dragDom.offsetLeft - dragDomWidth

            const minDragDomTop = dragDom.offsetTop
            const maxDragDomTop = screenHeight - 200

            // 获取到的值带px 正则匹配替换
            let styL = getStyle(dragDom, 'left')
            let styT = getStyle(dragDom, 'top')

            if (styL.includes('%')) {
                styL = +document.body.clientWidth * (+styL.replace(/%/g, '') / 100)
                styT = +document.body.clientHeight * (+styT.replace(/%/g, '') / 100)
            } else {
                styL = +styL.replace(/\px/g, '')
                styT = +styT.replace(/\px/g, '')
            }

            document.onmousemove = function (e) {
                // 通过事件委托，计算移动的距离
                let left = e.clientX - disX
                let top = e.clientY - disY

                // 边界处理
                // if (-(left) > minDragDomLeft) {
                //     left = -minDragDomLeft
                // } else if (left > maxDragDomLeft) {
                //     left = maxDragDomLeft
                // }

                if (-(top) > minDragDomTop) {
                    top = -minDragDomTop
                } else if (top > maxDragDomTop) {
                    top = maxDragDomTop
                }

                // 移动当前元素
                dragDom.style.cssText += `;left:${left + styL}px;top:${top + styT}px;`

                vnode.child.$emit('dragDialog')
            }

            document.onmouseup = function () {
                document.onmousemove = null
                document.onmouseup = null
            }
        }
    }
})

// v-dialogChange: 弹窗拉伸属性
// Vue.directive('dialogChange', {
//     bind(el, binding, vnode, oldVnode) {
//         new Vue({}).$nextTick(() => {
//             // 自定义属性，判断是否可拉伸
//             if (!binding.value) return
//             const dragDom = el.querySelector('.el-dialog')
//             const dragDomBody = el.querySelector('.el-dialog__body')
//             dragDomBody.style.overflow = 'auto'
//             const minHeight = 300
//             const minWidth = 400
//             // 右下角设置一个图标点击拖拽缩放大小 这是类名为mouse
//             let dragMouse = document.querySelector('.mouse')
//             // 鼠标拖拽
//             dragMouse.onmousedown = (e) => {
//                 // content区域
//                 const content = dragDom.parentNode.parentNode.parentNode.parentNode
//                 const disX = e.clientX - dragDom.offsetWidth
//                 const disY = e.clientY - dragDom.offsetHeight

//                 document.onmousemove = function (e) {
//                     e.preventDefault() // 移动时禁用默认事件
//                     // 通过事件委托，计算移动的距离e
//                     let width = e.clientX - disX
//                     let height = e.clientY - disY

//                     if (width > content.offsetWidth && height < content.offsetHeight) {
//                         if (height < minHeight) {
//                             height = minHeight
//                         }
//                         dragDom.style.height = `${height}px`
//                         // 减去头部高度
//                         dragDomBody.style.height = `${height - 120}px`
//                     } else if (width < content.offsetWidth && height > content.offsetHeight) {
//                         if (width < minWidth) {
//                             width = minWidth
//                         }
//                         dragDom.style.width = `${width}px`
//                     } else if (width < content.offsetWidth && height < content.offsetHeight) {
//                         if (height < minHeight) {
//                             height = minHeight
//                         }
//                         if (width < minWidth) {
//                             width = minWidth
//                         }
//                         dragDom.style.width = `${width}px`
//                         dragDom.style.height = `${height}px`
//                         // 减去头部高度
//                         dragDomBody.style.height = `${height - 120}px`
//                     }
//                 }
//                 document.onmouseup = function (e) {
//                     document.onmousemove = null
//                     document.onmouseup = null
//                 }
//                 return false
//             }
//         })
//     }
// })


