import req from "@/request.js";

const portal = window.context.portal;
export default {
	// 查询当前登录用户所属类型(管理员,区县,市级单位)
	getUserUnit(cb){
		req.get(portal + `/fill/bizWorkNews/v1/userAffiliatedUnit`).then(rep => {
			cb(rep.data);
		});
	},
	//分页
	ListGet(data,isAffirm, cb) {
		req.post(portal + `/fill/bizWorkNews/v1/queryInfo?isAffirm=${isAffirm}`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 新增或修改
	dynamicSaveOrUpdate(data,cb) {
		req.post(portal + `/fill/bizWorkNews/v1/saveOrUpdateEntity`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 新增
	addSave(data, cb) {
		req.post(portal + `/fill/bizWorkNews/v1/`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改
	detailId(id, cb) {
		req.post(portal + `/fill/bizWorkNews/v1/findById?id=${id}`).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改
	upData(data, cb) {
		req.post(portal + `/fill/bizWorkNews/v1/updateInfo`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除
	remove(ids,cb) {
	    req.remove(portal + `/fill/bizWorkNews/v1/?ids=`+ids).then(rep => {
	        cb(rep.data);
	    });
	},
	// remove(id) {
	// 	return new Promise((resolve, reject) => {
	// 		req.remove(portal + "/portalNewsNotice/v1/?ids=" + id).then(resp => {
	// 			resolve(resp.data);
	// 		}, error => {
	// 			reject(error);
	// 		})
	// 	})
	// },
	//排序
	saveProperty(data, cb) {
		req.post(portal + `/portalNewsNotice/v1/updateSequence`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 工作报告
	// 查询
	getWorkReports(data,cb) {
		req.post(portal + `/fill/bizReformWorkReport/v1/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 工作报告保存
	saveOrUpdate(data,cb) {
		req.post(portal + `/fill/bizReformWorkReport/v1/save`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 删除工作报告
	deleteWorkReports(id,cb) {
		req.post(portal + `/fill/bizReformWorkReport/v1/delete?id=${id}`).then(rep => {
			cb(rep.data);
		});
	},
	// 获取重大项目列表
	getProjectAllByUser(cb) {
		req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/userFetchProject`).then(rep => {
			cb(rep.data);
		});
	}
}
