/*!
 * node-sass: lib/binding.js
 */

var errors = require('./errors');

/**
 * Require binding
 */
module.exports = function(ext) {
  if (!ext.hasBinary(ext.getBinaryPath())) {
    if (!ext.isSupportedEnvironment()) {
      throw new Error(errors.unsupportedEnvironment());
    } else {
      throw new Error(errors.missingBinary());
    }
  }

  return require(ext.getBinaryPath());
};
