export interface GeolocationParams {
    targetAccuracy?: number;
    coordinate?: number;
    withReGeocode?: boolean;
    useCache?: boolean;
}
export interface GeolocationResult {
    longitude: number;
    latitude: number;
    accuracy: number;
    address: string;
    province: string;
    city: string;
    district: string;
    road: string;
    netType: string;
    operatorType: string;
    errorMessage: string;
    errorCode: number;
    isWifiEnabled: boolean;
    isGpsEnabled: boolean;
    isFromMock: boolean;
    isMobileEnabled: boolean;
    provider: string;
}
declare function getGeolocation(args: GeolocationParams): Promise<GeolocationResult>;
declare namespace getGeolocation {
    var version: {
        android: string;
        ios: string;
    };
}
export default getGeolocation;
