/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.util;

import com.artfess.base.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doGet(String url) {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        try {
            client.executeMethod((HttpMethod)method);
        }
        catch (URIException e) {
            logger.error("\u6267\u884cHTTP Get\u8bf7\u6c42\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            int n = 400;
            return n;
        }
        catch (IOException e) {
            logger.error("\u6267\u884cHTTP Get\u8bf7\u6c42" + url + "\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            int n = 400;
            return n;
        }
        finally {
            method.releaseConnection();
        }
        logger.debug("\u6267\u884cHTTP GET\u8bf7\u6c42\uff0c\u8fd4\u56de\u7801: {}", (Object)method.getStatusCode());
        return method.getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, String param) {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url + "?" + param);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        try {
            client.executeMethod((HttpMethod)method);
            if (method.getStatusCode() == 200) {
                String string = StreamUtils.copyToString((InputStream)method.getResponseBodyAsStream(), (Charset)Charset.forName("utf-8"));
                return string;
            }
        }
        catch (IOException e) {
            logger.error("\u6267\u884cHTTP Get\u8bf7\u6c42" + url + "\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, String queryString, String charset, boolean pretty) {
        logger.debug("http\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a" + queryString);
        StringBuffer response = new StringBuffer();
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        try {
            String line;
            if (StringUtil.isNotEmpty((String)queryString)) {
                method.setQueryString(URIUtil.encodeQuery((String)queryString));
            }
            HttpConnectionManagerParams managerParams = client.getHttpConnectionManager().getParams();
            managerParams.setConnectionTimeout(180000);
            managerParams.setSoTimeout(300000);
            client.executeMethod((HttpMethod)method);
            logger.debug("http\u7684\u8bf7\u6c42\u5730\u5740\u4e3a:" + url + ",\u8fd4\u56de\u7684\u72b6\u6001\u7801\u4e3a" + method.getStatusCode());
            BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), charset));
            while ((line = reader.readLine()) != null) {
                if (pretty) {
                    response.append(line).append(System.getProperty("line.separator"));
                    continue;
                }
                response.append(line);
            }
            reader.close();
        }
        catch (Exception e) {
            logger.error("\u6267\u884cHTTP Get\u8bf7\u6c42" + url + "\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01" + e);
            String string = response.toString();
            return string;
        }
        finally {
            method.releaseConnection();
        }
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, Object> map) {
        HttpClient httpClient = new HttpClient();
        PostMethod method = new PostMethod(url);
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                nameValuePairs.add(new NameValuePair(entry.getKey(), entry.getValue().toString()));
            }
        }
        NameValuePair[] param = nameValuePairs.toArray(new NameValuePair[nameValuePairs.size()]);
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        method.addParameters(param);
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)method);
            if (method.getStatusCode() == 200) {
                String string = StreamUtils.copyToString((InputStream)method.getResponseBodyAsStream(), (Charset)Charset.forName("utf-8"));
                return string;
            }
        }
        catch (UnsupportedEncodingException e1) {
            logger.error(e1.getMessage());
        }
        catch (IOException e) {
            logger.error("\u6267\u884cHTTP Post\u8bf7\u6c42" + url + "\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01" + e.toString());
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String reqStr, String contentType, String charset) {
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        try {
            HttpConnectionManagerParams managerParams = client.getHttpConnectionManager().getParams();
            managerParams.setConnectionTimeout(30000);
            managerParams.setSoTimeout(30000);
            method.setRequestEntity((RequestEntity)new StringRequestEntity(reqStr, contentType, "utf-8"));
            client.executeMethod((HttpMethod)method);
            logger.debug("\u8fd4\u56de\u7684\u72b6\u6001\u7801\u4e3a" + method.getStatusCode());
            if (method.getStatusCode() == 200) {
                String string = StreamUtils.copyToString((InputStream)method.getResponseBodyAsStream(), (Charset)Charset.forName(charset));
                return string;
            }
        }
        catch (UnsupportedEncodingException e1) {
            logger.error(e1.getMessage());
            String string = "";
            return string;
        }
        catch (IOException e) {
            logger.error("\u6267\u884cHTTP Post\u8bf7\u6c42" + url + "\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01" + e.toString());
            String string = "";
            return string;
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, HttpEntity entity) {
        CloseableHttpClient client = HttpClients.createSystem();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(entity);
        BufferedReader reader = null;
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            logger.debug("Status:" + response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() == 200) {
                String inputLine;
                reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuffer buffer = new StringBuffer();
                while ((inputLine = reader.readLine()) != null) {
                    buffer.append(inputLine);
                }
                reader.close();
                String string = buffer.toString();
                return string;
            }
        }
        catch (IOException ex) {
            logger.error("\u6267\u884chttp post\u8bf7\u6c42\u51fa\u9519,exception={}", (Object)ex.getMessage());
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

