/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.model.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cssc.model.manager.ModelTaskManager;
import com.artfess.cssc.model.model.ModelTask;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/model/modelTask/v1/"})
@Api(tags={"\u6a21\u578b\u8c03\u5ea6\u4efb\u52a1"})
@ApiGroup(group={"group_biz"})
public class ModelTaskController
extends BaseController<ModelTaskManager, ModelTask> {
    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<ModelTask> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ModelTask> queryFilter) {
        return ((ModelTaskManager)this.baseService).sliceQueryModelTask(queryFilter);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u6a21\u578b\u8c03\u5ea6\u4efb\u52a1")
    public CommonResult<String> create(@ApiParam(name="model", value="\u6a21\u578b\u8c03\u5ea6\u4efb\u52a1") @RequestBody ModelTask modelTask) {
        boolean result = ((ModelTaskManager)this.baseService).insertModelTask(modelTask);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u65b0\u589e\u6a21\u578b\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25!");
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u6a21\u578b\u8c03\u5ea6\u4efb\u52a1")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u6a21\u578b\u8c03\u5ea6\u4efb\u52a1") @RequestBody ModelTask modelTask) {
        try {
            boolean result = ((ModelTaskManager)this.baseService).updateModelTask(modelTask);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u6a21\u578b\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25!");
            }
            return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((ModelTaskManager)this.baseService).deleteModelTaskById(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult("\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/startUpJob"})
    @ApiOperation(value="\u542f\u52a8\u6a21\u578b\u8ba1\u7b97", httpMethod="POST", notes="\u542f\u52a8\u6a21\u578b\u8ba1\u7b97")
    public CommonResult<String> startUpJob(@ApiParam(name="id", value="\u6a21\u578bid", required=true) @RequestParam String id) throws Exception {
        return ((ModelTaskManager)this.baseService).remoteCommand(id, "startUp");
    }

    @PostMapping(value={"/stopJob"})
    @ApiOperation(value="\u505c\u6b62\u6a21\u578b\u8ba1\u7b97", httpMethod="POST", notes="\u505c\u6b62\u6a21\u578b\u8ba1\u7b97")
    public CommonResult<String> stopJob(@ApiParam(name="id", value="\u6a21\u578bid", required=true) @RequestParam String id) throws Exception {
        return ((ModelTaskManager)this.baseService).remoteCommand(id, "stop");
    }
}

