/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.jkjc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.JsonUtil;
import com.artfess.cssc.jkjc.dao.JkjcHealthDao;
import com.artfess.cssc.jkjc.manager.JkjcHealthManager;
import com.artfess.cssc.jkjc.model.JkjcHealth;
import com.artfess.cssc.jkjc.utli.HttpUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JkjcHealthManagerImpl
extends BaseManagerImpl<JkjcHealthDao, JkjcHealth>
implements JkjcHealthManager {
    @Value(value="${jkjc.health}")
    private String healthUrl;
    @Value(value="${jkjc.remoteWarn}")
    private String remoteWarn;
    @Value(value="${jkjc.remoteReport}")
    private String remoteReport;
    @Value(value="${jkjc.remoteOverview}")
    private String remoteOverview;

    @Override
    public Map<String, Object> getJsonHealth(LocalDate localDate) throws Exception {
        ObjectMapper mapper;
        JsonNode jsonNode;
        JsonNode data;
        int year = localDate.getYear();
        int monthValue = localDate.getMonthValue();
        int dayOfMonth = localDate.getDayOfMonth();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("areaCname", "\u6d77\u4e0a\u8fd0\u7ef4\u4e2d\u5fc3");
        map.put("farmCname", "\u534e\u80fd\u6c5f\u82cf\u5982\u4e1cH3");
        map.put("dataYear", year);
        map.put("dataMonth", monthValue);
        map.put("dataDay", dayOfMonth);
        String json = HttpUtil.post(this.healthUrl, map, null, null, 50000, 50000, null);
        if (StringUtils.isNotEmpty((CharSequence)json) && (data = (jsonNode = (mapper = new ObjectMapper()).readTree(json)).get("data")) != null) {
            Map resultMap = JsonUtil.toMap((String)data.toString());
            System.out.println(resultMap);
            System.out.println(data.asText());
            return resultMap;
        }
        return null;
    }

    @Override
    public Map<String, Object> getJsonRemoteOverview() throws Exception {
        ObjectMapper mapper;
        JsonNode jsonNode;
        JsonNode data;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("areaCname", "\u6d77\u4e0a\u8fd0\u7ef4\u4e2d\u5fc3");
        map.put("farmCname", "\u534e\u80fd\u6c5f\u82cf\u5982\u4e1cH3");
        String json = HttpUtil.post(this.healthUrl, map, null, null, 50000, 50000, null);
        if (StringUtils.isNotEmpty((CharSequence)json) && (data = (jsonNode = (mapper = new ObjectMapper()).readTree(json)).get("data")) != null) {
            Map resultMap = JsonUtil.toMap((String)data.toString());
            System.out.println(resultMap);
            System.out.println(data.asText());
            return resultMap;
        }
        return null;
    }
}

