/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.collect.mq;

import com.artfess.base.util.DateUtils;
import com.artfess.cssc.base.dao.FaultMessageDao;
import com.artfess.cssc.base.manager.FanInfoManager;
import com.artfess.cssc.base.model.FanInfo;
import com.artfess.cssc.base.model.FaultMessage;
import com.artfess.cssc.cms.manager.CmsStateManager;
import com.artfess.cssc.cms.model.CmsState;
import com.artfess.cssc.collect.dao.DataLogErrDao;
import com.artfess.cssc.collect.model.DataLogErr;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataCmsStateRabbitMq {
    private static final Logger log = LoggerFactory.getLogger(DataCmsStateRabbitMq.class);
    @Resource
    private CmsStateManager cmsStateManager;
    @Resource
    private FaultMessageDao faultMessageDao;
    @Resource
    private DataLogErrDao dataLogErrDao;
    @Resource
    private FanInfoManager fanInfoManager;
    private static Map<String, FaultMessage> msgMap = new HashMap<String, FaultMessage>();

    public void process(Message messageorigin, Channel channel) throws IOException {
        DataLogErr dataLogErr;
        String cmsState = "";
        JsonNode root = null;
        try {
            Jackson2JsonMessageConverter jackson2JsonMessageConverter = new Jackson2JsonMessageConverter();
            cmsState = (String)jackson2JsonMessageConverter.fromMessage(messageorigin);
        }
        catch (Exception e) {
            dataLogErr = new DataLogErr();
            dataLogErr.setSysName("cms");
            dataLogErr.setNode("\u63a5\u6536");
            dataLogErr.setErrorTime(LocalDateTime.now());
            dataLogErr.setErrorContent(e.getMessage());
            this.dataLogErrDao.insert((Object)dataLogErr);
            channel.basicNack(messageorigin.getMessageProperties().getDeliveryTag(), false, false);
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)cmsState)) {
                ObjectMapper mapper = new ObjectMapper();
                root = mapper.readTree(cmsState);
                boolean flag = true;
                if (!root.has("state_list") && !root.has("time")) {
                    flag = false;
                }
                if (!flag) {
                    DataLogErr dataLogErr2 = new DataLogErr();
                    dataLogErr2.setSysName("cms");
                    dataLogErr2.setNode("\u89e3\u6790");
                    dataLogErr2.setErrorTime(LocalDateTime.now());
                    dataLogErr2.setErrorContent("CMS\u72b6\u6001\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff01\u6570\u636e\u4e2d\u6ca1\u6709\u65f6\u95f4\u6233\u6216\u6ca1\u6709\u91c7\u96c6\u6570\u636e");
                    this.dataLogErrDao.insert((Object)dataLogErr2);
                    channel.basicNack(messageorigin.getMessageProperties().getDeliveryTag(), false, false);
                    return;
                }
                this.saveCmsState(root);
                this.analysisFaultMessage(root);
                channel.basicAck(messageorigin.getMessageProperties().getDeliveryTag(), false);
            } else {
                DataLogErr dataLogErr3 = new DataLogErr();
                dataLogErr3.setSysName("cms");
                dataLogErr3.setNode("\u89e3\u6790");
                dataLogErr3.setErrorTime(LocalDateTime.now());
                dataLogErr3.setErrorContent("cms \u72b6\u6001\u6570\u636e\u4e3a\u7a7a\uff01");
                this.dataLogErrDao.insert((Object)dataLogErr3);
                channel.basicNack(messageorigin.getMessageProperties().getDeliveryTag(), false, false);
            }
        }
        catch (Exception e1) {
            dataLogErr = new DataLogErr();
            dataLogErr.setSysName("cms");
            dataLogErr.setNode("\u89e3\u6790");
            dataLogErr.setErrorTime(LocalDateTime.now());
            dataLogErr.setErrorContent(e1.getMessage());
            this.dataLogErrDao.insert((Object)dataLogErr);
            channel.basicNack(messageorigin.getMessageProperties().getDeliveryTag(), false, false);
        }
    }

    private void saveCmsState(JsonNode data) throws Exception {
        try {
            long time = data.get("time").asLong();
            JsonNode fanListJson = data.get("state_list");
            Iterator fanState = fanListJson.iterator();
            ArrayList<CmsState> list = new ArrayList<CmsState>();
            while (fanState.hasNext()) {
                JsonNode stateData = (JsonNode)fanState.next();
                CmsState cmsState = new CmsState();
                cmsState.setFanState(stateData.get("windturbine_state").asText());
                cmsState.setFanCode(stateData.get("windturbine_name").asText());
                cmsState.setDriveChain(stateData.get("drive_chain_list").asText());
                cmsState.setTowerBaseObliquity(stateData.get("tower_base_obliquity_list").asText());
                cmsState.setEngineRoomObliquity(stateData.get("engine_room_obliquity_list").asText());
                cmsState.setBladeVibration(stateData.get("blade_vibration_list").asText());
                cmsState.setBladeStress(stateData.get("blade_stress_list").asText());
                cmsState.setBoltComponent(stateData.get("bolt_component_list").asText());
                cmsState.setTowerSway(stateData.get("tower_sway_list").asText());
                cmsState.setOil(stateData.get("oil").asText());
                cmsState.setCollTimeStamp(time);
                cmsState.setCollTime(DateUtils.timestamToDatetime((long)time));
                cmsState.setCreateTime(LocalDateTime.now());
                list.add(cmsState);
            }
            if (!CollectionUtils.isEmpty(list)) {
                this.cmsStateManager.saveBatch(list);
            }
        }
        catch (Exception e) {
            DataLogErr dataLogErr = new DataLogErr();
            dataLogErr.setSysName("cms");
            dataLogErr.setNode("\u5165\u5e93");
            dataLogErr.setErrorTime(LocalDateTime.now());
            dataLogErr.setErrorContent(e.getMessage());
            this.dataLogErrDao.insert((Object)dataLogErr);
        }
    }

    private void analysisFaultMessage(JsonNode data) throws Exception {
        long time = data.get("time").asLong();
        if (data.has("state_list")) {
            JsonNode fanListJson = data.get("state_list");
            for (JsonNode stateData : fanListJson) {
                String fanState = stateData.get("windturbine_state").asText();
                String fanCode = stateData.get("windturbine_name").asText();
                if (!fanState.equals("3")) continue;
                FanInfo fanInfo = this.fanInfoManager.getByFanCode(fanCode);
                Iterator statesListIt = stateData.fields();
                while (statesListIt.hasNext()) {
                    FaultMessage messageInfo;
                    JsonNode listJson;
                    String key;
                    Map.Entry states = (Map.Entry)statesListIt.next();
                    if (((JsonNode)states.getValue()).isArray()) {
                        key = (String)states.getKey();
                        if (!key.equals("oil") && !key.equals("bolt_component_list")) {
                            listJson = (JsonNode)states.getValue();
                            for (JsonNode listData : listJson) {
                                FaultMessage messageInfo2;
                                String state = listData.get("position_state").asText();
                                String equ = listData.get("position_name").asText();
                                String mapKeys = fanCode + "_" + key + "_" + equ + "_" + state;
                                if (state.equals("3")) {
                                    if (msgMap.containsKey(mapKeys)) continue;
                                    messageInfo2 = new FaultMessage();
                                    messageInfo2.setMsgSys("cms");
                                    messageInfo2.setMsgType("alarm");
                                    messageInfo2.setMsgFan(fanCode);
                                    messageInfo2.setMsgFanType(fanInfo.getFanType());
                                    messageInfo2.setMsgCode(state);
                                    messageInfo2.setMsgEqu(equ);
                                    messageInfo2.setMsgContent(equ + "\u62a5\u8b66\uff01");
                                    messageInfo2.setMsgStartTime(DateUtils.timestamToDatetime((long)time));
                                    this.faultMessageDao.insert((Object)messageInfo2);
                                    msgMap.put(mapKeys, messageInfo2);
                                    continue;
                                }
                                if (!state.equals("1") || !msgMap.containsKey(mapKeys)) continue;
                                messageInfo2 = msgMap.get(mapKeys);
                                messageInfo2.setMsgEndTime(DateUtils.timestamToDatetime((long)time));
                                this.faultMessageDao.updateById((Object)messageInfo2);
                                msgMap.remove(mapKeys);
                            }
                        }
                        if (!key.equals("bolt_component_list")) continue;
                        listJson = (JsonNode)states.getValue();
                        for (JsonNode listData : listJson) {
                            String equ = listData.get("component_name").asText();
                            JsonNode boltData = listData.get("bolt_list");
                            Iterator boltIt = boltData.iterator();
                            while (boltIt.hasNext()) {
                                FaultMessage messageInfo3;
                                String state = boltData.get("position_state").asText();
                                String positionName = boltData.get("position_name").asText();
                                equ = equ + positionName;
                                String mapKeys = fanCode + "_" + key + "_" + equ + "_" + state;
                                if (state.equals("3")) {
                                    if (msgMap.containsKey(mapKeys)) continue;
                                    messageInfo3 = new FaultMessage();
                                    messageInfo3.setMsgSys("cms");
                                    messageInfo3.setMsgType("alarm");
                                    messageInfo3.setMsgFan(fanCode);
                                    messageInfo3.setMsgFanType(fanInfo.getFanType());
                                    messageInfo3.setMsgCode(state);
                                    messageInfo3.setMsgEqu(equ);
                                    messageInfo3.setMsgContent(equ + "\u62a5\u8b66\uff01");
                                    messageInfo3.setMsgStartTime(DateUtils.timestamToDatetime((long)time));
                                    this.faultMessageDao.insert((Object)messageInfo3);
                                    msgMap.put(mapKeys, messageInfo3);
                                    continue;
                                }
                                if (!state.equals("1") || !msgMap.containsKey(mapKeys)) continue;
                                messageInfo3 = msgMap.get(mapKeys);
                                messageInfo3.setMsgEndTime(DateUtils.timestamToDatetime((long)time));
                                this.faultMessageDao.updateById((Object)messageInfo3);
                                msgMap.remove(mapKeys);
                            }
                        }
                        continue;
                    }
                    key = (String)states.getKey();
                    if (!key.equals("oil")) continue;
                    listJson = (JsonNode)states.getValue();
                    String state = listJson.get("position_state").asText();
                    String mapKeys = fanCode + "_" + key + "_" + state;
                    if (state.equals("3")) {
                        if (msgMap.containsKey(mapKeys)) continue;
                        messageInfo = new FaultMessage();
                        messageInfo.setMsgSys("cms");
                        messageInfo.setMsgType("alarm");
                        messageInfo.setMsgFan(fanCode);
                        messageInfo.setMsgFanType(fanInfo.getFanType());
                        messageInfo.setMsgCode(state);
                        messageInfo.setMsgEqu("\u6cb9\u6db2\u4f20\u611f\u5668");
                        messageInfo.setMsgContent("\u6cb9\u6db2\u4f20\u611f\u5668\u62a5\u8b66\uff01");
                        messageInfo.setMsgStartTime(DateUtils.timestamToDatetime((long)time));
                        this.faultMessageDao.insert((Object)messageInfo);
                        msgMap.put(mapKeys, messageInfo);
                        continue;
                    }
                    if (!state.equals("1") || !msgMap.containsKey(mapKeys)) continue;
                    messageInfo = msgMap.get(mapKeys);
                    messageInfo.setMsgEndTime(DateUtils.timestamToDatetime((long)time));
                    this.faultMessageDao.updateById((Object)messageInfo);
                    msgMap.remove(mapKeys);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

