/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.base.manager.PointInfoManager;
import com.artfess.cssc.base.model.PointInfo;
import com.artfess.poi.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/biz/base/pointInfo/v1/"})
@Api(tags={"\u70b9\u4f4d\u8868\u4fe1\u606f"})
@ApiGroup(group={"group_biz"})
public class PointInfoController
extends BaseController<PointInfoManager, PointInfo> {
    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u70b9\u4f4d\u4fe1\u606f\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u70b9\u4f4d\u4fe1\u606f") @RequestBody PointInfo pointInfo) {
        boolean result = ((PointInfoManager)this.baseService).insertPointInfo(pointInfo);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u70b9\u4f4d\u4fe1\u606f")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u70b9\u4f4d\u4fe1\u606f") @RequestBody PointInfo pointInfo) {
        boolean result = ((PointInfoManager)this.baseService).updatePointInfo(pointInfo);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u70b9\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
        return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u70b9\u4f4d\u4fe1\u606f\u5217\u8868", httpMethod="POST", notes="\u70b9\u4f4d\u4fe1\u606f\u5217\u8868")
    public List<PointInfo> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<PointInfo> queryFilter) throws Exception {
        return ((PointInfoManager)this.baseService).queryNoPage(queryFilter);
    }

    @PostMapping(value={"/updateSequence"})
    @ApiOperation(value="\u4fee\u6539\u70b9\u4f4d\u6392\u5e8f\u53f7", httpMethod="POST", notes="\u4fee\u6539\u70b9\u4f4d\u6392\u5e8f\u53f7")
    @ApiImplicitParam(name="map", value="key:\u70b9\u4f4did,value:\u6392\u5e8f\u53f7", required=true)
    public CommonResult<String> updateSequence(@RequestBody HashMap<String, Integer> map) throws Exception {
        ((PointInfoManager)this.baseService).updateSequence(map);
        return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u70b9\u4f4d\u5bfc\u5165", httpMethod="POST", notes="\u70b9\u4f4d\u5bfc\u5165")
    public CommonResult<String> importData(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody MultipartFile file) throws Exception {
        ((PointInfoManager)this.baseService).importData(file);
        return new CommonResult(true, "\u70b9\u4f4d\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u70b9\u4f4d\u5bfc\u51fa", httpMethod="GET", notes="\u70b9\u4f4d\u5bfc\u51fa")
    public void export(HttpServletResponse response, @ApiParam(name="ids", value="ids", required=false) @RequestParam String ids, @ApiParam(name="pointType", value="pointType", required=false) @RequestParam Integer pointType) throws Exception {
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        if (StringUtil.isNotEmpty((String)ids)) {
            filter.addFilter("id_", (Object)ids.split(","), QueryOP.IN, FieldRelation.AND);
        }
        if (BeanUtils.isNotEmpty((Object)pointType)) {
            filter.addFilter("point_type_", (Object)pointType, QueryOP.EQUAL, FieldRelation.AND);
        }
        List sorter = filter.getSorter();
        sorter.add(new FieldSort("point_type_", Direction.ASC));
        sorter.add(new FieldSort("sn_", Direction.ASC));
        filter.setSorter(sorter);
        PageList pointInfos = ((PointInfoManager)this.baseService).query(filter);
        ArrayList<Map> list = new ArrayList<Map>();
        if (BeanUtils.isNotEmpty((Object)pointInfos.getRows())) {
            for (PointInfo pointInfo : pointInfos.getRows()) {
                list.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)((Object)pointInfo))));
            }
        }
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("pointName", "\u70b9\u4f4d\u540d\u79f0");
        exportMap.put("varName", "\u70b9\u4f4d\u7f16\u7801");
        exportMap.put("dataType", "\u6570\u636e\u7c7b\u578b");
        exportMap.put("pointType", "\u70b9\u4f4d\u7c7b\u578b");
        exportMap.put("unit", "\u6570\u636e\u5355\u4f4d");
        exportMap.put("sn", "\u6392\u5e8f");
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u70b9\u4f4d\u4fe1\u606f", (int)22, exportMap, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)exportFile, (String)"\u70b9\u4f4d\u4fe1\u606f\u5bfc\u51fa", (HttpServletResponse)response);
    }
}

