import 'babel-polyfill'
//引入ui
import ElementUI from "element-ui";
import HotentUi from "bpm_el_ui"; 
import "bpm_el_ui/lib/bpm_el_ui.css";
import "bpm_el_ui/src/assets/css/element-variables.scss"
import "@/assets/css/element-custom.scss";

import Vue from "vue";
import App from "./App.vue";
import store from "./store";
import router from "./router";
import req from "@/request.js";
import qs from 'qs'
Vue.prototype.qs = qs

// 插件
import Print from "@/plugs/print"; //打印插件 源码修改过 getStyle方法
import i18n from "@/lang/index.js";
import moment from "moment"; //日期格式化插件
import VueUeditorWrap from "vue-ueditor-wrap"; //引入富文本组件
import VueClipboard from "vue-clipboard2";
import Viewer from "v-viewer"; //图片预览插件
import "viewerjs/dist/viewer.css";
import AMap from 'vue-amap';//高德地图插件
import Video from 'video.js'
import 'video.js/dist/video-js.css'
import CollapseTransition from 'element-ui/lib/transitions/collapse-transition';
import Formulas from "@/formulas.js";
import "@/directive.js";
import deepmerge from "deepmerge";
import validate from "@/validate.js";
import dict from "@/lang/dict.js";
// import echarts from "echarts"; //引入echarts
// Vue.prototype.$echarts = echarts;
// import utils from "@/utils.js";

// 全局组件
import HtSubmitButton from "@/components/common/HtSubmitButton.vue";
import HtDeleteButton from "@/components/common/HtDeleteButton.vue";
import ExportData from "@/components/ImportExportData/ExportData/ExportData.vue";
import ImportData from "@/components/ImportExportData/ImportData/ImportData.vue";
import CommonDialog from "@/components/dialog/CommonDialog.vue";
import DictSelect from "@/components/dict/DictSelect.vue";
import svgIcon from "@/components/global/svgIcon.vue";

// 事件总线
import eventBus from './api/bus.js'
Vue.use(eventBus);



Vue.prototype.$video = Video
Vue.config.debug = true;
Vue.prototype.$http = req;
Vue.use(AMap);
AMap.initAMapApiLoader({
  key: "babe07289a50fc3eda093e6ccea2f8a4",
  plugin: ['AMap.Autocomplete', 'AMap.PlaceSearch', 'AMap.Scale', 'AMap.OverView', 'AMap.ToolBar', 'AMap.MapType', 'AMap.PolyEditor', 'AMap.CircleEditor','AMap.Geolocation'],
  // 默认高德 sdk 版本为 1.4.4
  v: '1.4.4'
});
Vue.use(Viewer, {
  defaultOptions: {
    zIndex: 9999,
    toolbar: true
  }
})
Vue.use(VueClipboard);
Vue.use(ElementUI, {
  i18n: (key, value) => i18n.t(key, value),
  size: "small"
});

Vue.use(HotentUi, {
  i18n: (key, value) => i18n.t(key, value)
});

Vue.use(Print);
Vue.use(Formulas);

// 注册全局组件
Vue.component('svgIcon', svgIcon);
Vue.component("HtSubmitButton", HtSubmitButton);
Vue.component("HtDeleteButton", HtDeleteButton);
Vue.component("DictSelect", DictSelect);
Vue.component("CommonDialog", CommonDialog);
Vue.filter('formatDate', function(value,pattern = "YYYY-MM-DD HH:mm:ss") {
  if (!value){
    return "";
  }
  return moment(value).format(pattern)
})
Vue.component("vue-ueditor-wrap", VueUeditorWrap);
Vue.component(CollapseTransition.name, CollapseTransition)
Vue.component('ExportData', ExportData);
Vue.component('ImportData', ImportData);


window.app = new Vue({
  store,
  router,
  i18n,
  render: function (createElement) {
    if (
      "-ms-scroll-limit" in document.documentElement.style &&
      "-ms-ime-align" in document.documentElement.style
    ) {
      window.addEventListener(
        "hashchange",
        () => {
          var currentPath = window.location.hash.slice(1);
          if (this.$route.path !== currentPath) {
            this.$router.push(currentPath);
          }
        },
        false
      );
    }
    return createElement(App);
  }
}).$mount("#root");

let validateLocal = localStorage.getItem("lang");
let currentLocal = validateLocal || "zh-CN";
app.$validator.locale = currentLocal;

if (app.$validator) {
  for (let rule in validate) {
    app.$validator.rules[rule] = validate[rule];
  }
  app.$validator.dictionary.container = deepmerge(
    dict,
    app.$validator.dictionary.container,
    { clone: true }
  );
}

// 日期控件格式化
if ("zh-CN" == currentLocal) {
  moment.locale("zh-cn");
} else {
  moment.locale("en");
}

// el-tooltip 默认显示
Vue.prototype.$tooltipplacement = "bottom";
