package com.artfess.base.enums;

import com.google.common.collect.Lists;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * 指标单位枚举
 */
@Getter
public enum TargetUnitEnum {
    /**
     *
     */
    OY("1", "欧元", BigDecimal.ONE),

    WO("2", "万欧", new BigDecimal(10000)),

    YO("3", "亿欧", new BigDecimal(100000000)),

    ;

    TargetUnitEnum(String type, String desc, BigDecimal value){
        this.type = type;
        this.value = value;
        this.desc = desc;
    }

    //单位类型
    private String type;

    private String desc;

    private BigDecimal value;


    public static BigDecimal getValue(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        TargetUnitEnum[] values = values();
        for (TargetUnitEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getValue();
            }
        }
        return null;
    }

}
