package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--新项目收入贡献填报详情表
 *
 * @author 黎沐华
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-02-21
 */
@Data
@ApiModel(value = "QfOperationSopD对象", description = "运营--新项目收入贡献填报详情表")
public class QfOperationSopD extends BaseModel<QfOperationSopD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @Excel(name = "SOP", column = "A")
    @ApiModelProperty(value = "SOP\n" +
            "项目开始日期")
    @TableField("sop_")
    private String sop;

    @Excel(name = "Strategic group\n" +
            "客户", column = "B")
    @ApiModelProperty(value = "客户")
    @TableField("customer_")
    private String customer;

    @Excel(name = "Brand\n" +
            "品牌", column = "C")
    @ApiModelProperty(value = "品牌")
    @TableField("brand_")
    private String brand;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "Model\n" +
            "型号", column = "D")
    @ApiModelProperty(value = "型号")
    @TableField("model_")
    private String model;

    @Excel(name = "plant\n" +
            "子企业代码", column = "E")
    @ApiModelProperty(value = "企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;


    @Excel(name = "budget(YTD KEUR)\n" +
            "累计预算（千欧元）", column = "F")
    @ApiModelProperty(value = "累计预算（千欧元）")
    @TableField("budget_ytd_")
    private BigDecimal budgetYtd;

    @Excel(name = "Actual(YTD KEUR)\n" +
            "累计实际（千欧元", column = "G")
    @ApiModelProperty(value = "当年累计实际销售额")
    @TableField("actual_ytd_")
    private BigDecimal actualYtd;

    @ApiModelProperty(value = "当月实际销售额")
    @TableField("actual_")
    private BigDecimal actual;

    @ApiModelProperty(value = "当月预算销售额")
    @TableField("budget_")
    private BigDecimal budget;

    @ApiModelProperty(value = "备注")
    @TableField("remarks")
    private String remarks;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
