package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--集团持续改进数据-分公司填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-21
 */
@Data
@ApiModel(value="QfOperationCipD对象", description="运营--集团持续改进数据-分公司填报详情表")
public class QfOperationCompanyCipD extends BaseModel<QfOperationCompanyCipD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "plants\n" +
            "公司", column = "A")
    @ApiModelProperty(value = "企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "洲别【字典】")
    @TableField("enterprise_area_")
    private String enterpriseArea;

    @ApiModelProperty(value = "企业名称")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）")
    @TableField("enterprise_type_")
    private Integer enterpriseType;

    @Excel(name = "budget", column = "B")
    @ApiModelProperty(value = "预算数据")
    @TableField("budget_")
    private BigDecimal budget;

    @Excel(name = "actual", column = "C")
    @ApiModelProperty(value = "实际数据")
    @TableField("actual_")
    private BigDecimal actual;


    @Excel(name = "variance", column = "D")
    @ApiModelProperty(value = "差额（实际-预算）")
    @TableField("variance_")
    private BigDecimal variance;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
