package com.artfess.cqlt.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.WebUtil;
import com.artfess.cqlt.dao.QfReportLogDao;
import com.artfess.cqlt.manager.QfReportLogManager;
import com.artfess.cqlt.model.QfReportLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;

/**
 * 报表导入日志 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-07-21
 */
@Service
public class QfReportLogManagerImpl extends BaseManagerImpl<QfReportLogDao, QfReportLog> implements QfReportLogManager {

    @Resource
    private BaseContext baseContext;

    @Override
    public void saveReportInfo(String reportStatus, String msg, String reportType, Integer year, Integer month) {
        QfReportLog qfReportLog = new QfReportLog();
        qfReportLog.setReportYear(year);
        qfReportLog.setReprotStatus(reportStatus);
        qfReportLog.setReportMonth(month);
        qfReportLog.setReportTime(LocalDateTime.now());
        qfReportLog.setErrMsg(msg);
        qfReportLog.setReportType(reportType);
        qfReportLog.setReportUserId(baseContext.getCurrentUserId());
        qfReportLog.setReportUserName(baseContext.getCurrentUserName());
        this.baseMapper.insert(qfReportLog);
    }
}
