package com.artfess.cqlt.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.vo.EnterpriseInfoVo;

import java.util.List;
import java.util.Map;

/**
 * 境外企业信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author lxk
 * @since 2023-02-10
 */
public interface QfEnterpriseInfoManager extends BaseManager<QfEnterpriseInfo> {

    CommonResult insertInfo(QfEnterpriseInfo info);

    CommonResult updateInfoById(QfEnterpriseInfo info);

    CommonResult<List<QfEnterpriseInfo>> getTree();

    Map<String, QfEnterpriseInfo> getEnterpriseInfoMap(QfEnterpriseInfo info);

    List<EnterpriseInfoVo> getAreaTree(QueryFilter<QfEnterpriseInfo> queryFilter);

    QfEnterpriseInfo findByCode(String code);

    /**
     * 获取集团信息
     * @return
     */
    QfEnterpriseInfo getGroup();
}
