package com.artfess.cqlt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.manager.QfFinanceLeaseDManager;
import com.artfess.cqlt.manager.QfFinanceLiquidityDetailManager;
import com.artfess.cqlt.manager.QfFinanceLoanDManager;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 周资金大屏统计宽表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@Slf4j
@RestController
@Api(tags = "大屏统计--资金主题")
@RequestMapping("/qf/money/statistical/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfWeeklyCashStatisticalController {

    @Autowired
    private QfFinanceLiquidityDetailManager financeLiquidityDetailManager;

    @Autowired
    private QfFinanceLoanDManager financeLoanDManager;

    @Autowired
    private QfFinanceLeaseDManager financeLeaseDManager;

    @Autowired
    private QfFinancialStatisticalManager financialStatisticalManager;

    @PostMapping("/poolPlanData")
    @ApiOperation(value = "资金池公司银行实时余额", response = FaTargetRespVo.class)
    public CommonResult<String> poolPlanData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaReportRespVo> data = financeLiquidityDetailManager.poolPlanData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping("/groupPlanData")
    @ApiOperation(value = "集团银行实时余额", response = FaTargetRespVo.class)
    public CommonResult<String> groupPlanData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaReportRespVo> data = financeLiquidityDetailManager.groupPlanData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping("/companyPlanData")
    @ApiOperation(value = "非资金池公司银行实时余额", response = FaTargetRespVo.class)
    public CommonResult<String> companyPlanData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaReportRespVo> data = financeLiquidityDetailManager.companyPlanData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping("/chinaCompanyData")
    @ApiOperation(value = "中国区公司银行实时余额", response = FaTargetRespVo.class)
    public CommonResult<String> chinaCompanyData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaReportRespVo> data = financeLiquidityDetailManager.chinaCompanyData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping("/oneLevelData")
    @ApiOperation(value = "资金大屏一级指标统计接口", response = FaTargetRespVo.class)
    public CommonResult<String> oneLevelData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = financialStatisticalManager.moneyData(t);
        return CommonResult.success(data, null);
    }
    @PostMapping("/fromUnderData")
    @ApiOperation("资金大屏当前以及下撰指标统计接口")
    public CommonResult<String> fromUnderData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = financialStatisticalManager.fromUnderData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping("/dataAnalysis")
    @ApiOperation("数据分析接口")
    public CommonResult<String> dataAnalysis(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = financialStatisticalManager.dataAnalysis(t);
        return CommonResult.success(data, null);
    }

}
