package com.artfess.workflow.runtime.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.workflow.runtime.model.BpmPrintRecord;
import com.artfess.workflow.runtime.params.BpmPrintRecordObject;

/**
 * 
 * <pre> 
 * 描述：流程打印文件管理表 处理接口
 * 构建组：x7
 * 作者:zhangxw
 * 邮箱:zhangxw@jee-soft.cn
 * 日期:2020-05-23 19:58:35
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
public interface BpmPrintRecordManager extends BaseManager<BpmPrintRecord>{
	/**
	 * 根据实例节点等信息获取打印文件的最后版本
	 * @param procInstId
	 * @param nodeId
	 * @param templateId
	 * @return
	 */
	BpmPrintRecord getLastVersion(String procInstId,String nodeId,String templateId);
	/**
	 * 清除最后版本标识
	 * @param procInstId
	 * @param nodeId
	 * @param templateId
	 */
	void cleanLastVersion(String procInstId,String nodeId,String templateId);
	
	/**
	 * 添加打印记录
	 * @param printRecordObject
	 * @return
	 */
	CommonResult<String> addPrintLog(BpmPrintRecordObject printRecordObject);
}
