/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.exception.BaseException;
import com.artfess.uc.manager.TenantAuthManager;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.manager.TenantTypeManager;
import com.artfess.uc.model.TenantAuth;
import com.artfess.uc.model.TenantManage;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/tenantManage/v1"})
@Api(tags={"\u79df\u6237\u7ba1\u7406 "})
@ApiGroup(group={"group_uc"})
public class TenantManageController
extends BaseController<TenantManageManager, TenantManage> {
    @Resource
    TenantManageManager tenantManageManager;
    @Resource
    TenantTypeManager tenantTypeManager;
    @Resource
    TenantAuthManager tenantAuthManager;
    @Resource
    WorkflowFeignService workflowFeignService;
    @Resource
    SaaSConfig saasConfig;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u79df\u6237\u7ba1\u7406 \u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u79df\u6237\u7ba1\u7406 \u5217\u8868")
    public PageList<TenantManage> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        User user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            ArrayList<String> authTypeIds = new ArrayList<String>();
            ArrayList<String> authTenantIds = new ArrayList<String>();
            List<TenantAuth> auths = this.tenantAuthManager.getByUserId(null, null, user.getId());
            if (BeanUtils.isNotEmpty(auths)) {
                for (TenantAuth tenantAuth : auths) {
                    if (StringUtil.isEmpty((String)tenantAuth.getTenantId())) {
                        authTypeIds.add(tenantAuth.getTypeId());
                        continue;
                    }
                    authTenantIds.add(tenantAuth.getTenantId());
                }
            }
            if (BeanUtils.isEmpty(authTypeIds) && BeanUtils.isEmpty(authTenantIds)) {
                authTypeIds.add("0");
                authTenantIds.add("0");
            }
            if (BeanUtils.isNotEmpty(authTypeIds)) {
                queryFilter.addFilter("TYPE_ID_", authTypeIds, QueryOP.IN, FieldRelation.OR, "auth");
            }
            if (BeanUtils.isNotEmpty(authTenantIds)) {
                queryFilter.addFilter("ID_", authTenantIds, QueryOP.IN, FieldRelation.OR, "auth");
            }
        }
        PageList pageList = this.tenantManageManager.queryWithType(queryFilter);
        return pageList;
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u79df\u6237\u7ba1\u7406 \u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79df\u6237\u7ba1\u7406 \u6570\u636e\u8be6\u60c5")
    public TenantManage get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        TenantManage tenantManage;
        if (StringUtil.isEmpty((String)id)) {
            id = "-1";
        }
        if (null == (tenantManage = (TenantManage)this.tenantManageManager.get((Serializable)((Object)id)))) {
            return null;
        }
        if (this.saasConfig.isEnable()) {
            tenantManage.setIsViewPartThree(false);
        } else {
            tenantManage.setIsViewPartThree(true);
        }
        return tenantManage;
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7ba1\u7406 \u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7ba1\u7406 \u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="tenantManage", value="\u79df\u6237\u7ba1\u7406 \u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody TenantManage tenantManage) throws Exception {
        String msg = "\u6dfb\u52a0\u79df\u6237\u7ba1\u7406 \u6210\u529f";
        if (this.saasConfig.isEnable()) {
            tenantManage.setIsPartThree(0);
        }
        if (StringUtil.isEmpty((String)tenantManage.getId())) {
            this.tenantManageManager.create((Model)tenantManage);
        } else {
            String tenantId;
            List tasList;
            TenantManage oldManage;
            if ("disabled".equals(tenantManage.getStatus()) && "enable".equals((oldManage = (TenantManage)this.tenantManageManager.get((Serializable)((Object)tenantManage.getId()))).getStatus()) && BeanUtils.isNotEmpty((Object)(tasList = this.workflowFeignService.getTaskListByTenantId(tenantId = tenantManage.getId()))) && tasList.size() > 0) {
                throw new BaseException("\u8be5\u79df\u6237\u4ecd\u6709\u4efb\u52a1\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\uff01");
            }
            this.tenantManageManager.update((Model)tenantManage);
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.set((Object)"type_id_", (Object)tenantManage.getTypeId());
            wrapper.eq((Object)"tenant_id_", (Object)tenantManage.getId());
            this.tenantAuthManager.update((Wrapper)wrapper);
            msg = "\u4fdd\u5b58\u6210\u529f";
        }
        return new CommonResult(true, msg, (Object)tenantManage.getId());
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79df\u6237\u7ba1\u7406 \u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u79df\u6237\u7ba1\u7406 \u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.tenantManageManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"checkCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u79df\u6237\u7c7b\u578b\u7f16\u7801\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u79df\u6237\u7c7b\u578b\u7f16\u7801\u662f\u5426\u5b58\u5728")
    public boolean checkCode(@ApiParam(name="code", value="\u79df\u6237\u7c7b\u578b\u7f16\u7801") @RequestParam String code) throws Exception {
        TenantManage tenant = this.tenantManageManager.getByCode(code);
        return BeanUtils.isNotEmpty((Object)((Object)tenant));
    }

    @RequestMapping(value={"getTenantByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u7f16\u7801\u83b7\u53d6\u79df\u6237\u7c7b\u578b", httpMethod="GET", notes="\u901a\u8fc7\u7f16\u7801\u83b7\u53d6\u79df\u6237\u7c7b\u578b")
    public TenantManage getTenantByCode(@ApiParam(name="code", value="\u79df\u6237\u7c7b\u578b\u7f16\u7801") @RequestParam String code) throws Exception {
        return this.tenantManageManager.getByCode(code);
    }

    @RequestMapping(value={"setThreeAdmin"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f00\u542f\u6216\u5173\u95ed\u4e09\u5458\u7ba1\u7406", httpMethod="POST", notes="\u5f00\u542f\u6216\u5173\u95ed\u4e09\u5458\u7ba1\u7406")
    public CommonResult<String> setThreeAdmin(@ApiParam(name="isPartThree", value="\u662f\u5426\u5f00\u542f\u4e09\u5458\u7ba1\u7406\uff080\uff1a\u5426 1\uff1a\u662f\uff09") @RequestParam Integer isPartThree, @ApiParam(name="tenantId", value="\u79df\u6237ID", required=true) @RequestParam String tenantId) throws Exception {
        this.tenantManageManager.setThreeAdmin(isPartThree, tenantId);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f");
    }
}

