package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 报表导入类型
 */
@Getter
public enum ReportTypeEnum {
    PL_ACTUAL("1", "利润实际表"),

    PL_BUDGET("2", "利润预算表"),

    BS_ACTUAL("3", "负债实际表"),

    BS_BUDGET("4", "负债预算表"),

    CF_ACTUAL("5","现金流量实际表"),

    CF_BUDGET("6","现金流量预算表"),

    HR_ACTUAL("7","人资表"),

    ;

    ReportTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        ReportTypeEnum[] values = values();
        for (ReportTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
