package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 *  贷款明细类型
 */
@Getter
public enum LoanDataTypeEnum {
    /**
     *
     */
    ONE("1", "内保外贷"),

    TWO("2", "自主融资"),


    ;

    LoanDataTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        LoanDataTypeEnum[] values = values();
        for (LoanDataTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        LoanDataTypeEnum[] values = values();
        for (LoanDataTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
