/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.util.StringUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CommonUtil {
    public static final long HOURS_PER_DAY = 24L;
    public static final long SECS_PER_MIN = 60L;
    public static final long MINS_PER_HOUR = 60L;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int DEFAULT_SCALE = 20;

    public static Map<String, Object> decodeMap(String value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty(value)) {
            String[] valueArray;
            for (String str : valueArray = value.trim().split(";")) {
                if (!str.contains("=")) continue;
                String[] subValueArray = str.trim().split("=");
                if (subValueArray.length == 1) {
                    result.put(subValueArray[0].trim(), "");
                    continue;
                }
                result.put(subValueArray[0].trim(), subValueArray[1].trim());
            }
        }
        return result;
    }

    public static String encodeMap(Map<String, Object> map) {
        String result = "";
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            String value = "";
            if (obj != null) {
                value = obj + "";
            }
            result = result + key + "=" + value + ";";
        }
        return result;
    }

    public static String createGUID() {
        return UUID.randomUUID().toString().toUpperCase().replaceAll("-", "");
    }

    public static String createFileFullName(String path, String fileName, String fileKind) {
        StringBuffer sb = new StringBuffer();
        sb.append(StringUtil.isEmpty(path) ? "" : path);
        sb.append("/");
        sb.append(StringUtil.isEmpty(fileName) ? "" : fileName);
        if (StringUtil.isNotEmpty(fileKind)) {
            sb.append(".").append(fileKind);
        }
        return sb.toString();
    }

    public static Timestamp getCurrentDateTime() {
        return new Timestamp(new java.util.Date().getTime());
    }

    public static Date getCurrentDate() {
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(new java.util.Date()));
    }

    public static java.util.Date trunc(java.util.Date value) throws ParseException {
        String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(value);
        return new SimpleDateFormat("yyyy-MM-dd").parse(dateStr);
    }

    public static java.util.Date parseDateTime(String value) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value);
    }

    public static Date getYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(CommonUtil.getCurrentDate());
        calendar.add(5, -1);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getTomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(CommonUtil.getCurrentDate());
        calendar.add(5, 1);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Time getCurrentTime() {
        return Time.valueOf(new SimpleDateFormat("HH:mm:ss").format(new java.util.Date()));
    }

    public static int getYear(java.util.Date date) {
        CommonUtil.verification(date != null, "getYear\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(java.util.Date date) {
        CommonUtil.verification(date != null, "getMonth\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay(java.util.Date date) {
        CommonUtil.verification(date != null, "getDay\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getHour(java.util.Date date) {
        CommonUtil.verification(date != null, "getHour\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(10);
    }

    public static int getMinute(java.util.Date date) {
        CommonUtil.verification(date != null, "getMinute\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static Date getFirstDateOfYear(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getFirstDateOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getLastDateOfYear(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, 1);
        calendar.set(2, 0);
        calendar.set(5, 0);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static String getSpecifiedDayBefore(String pattern, String specifiedDay) throws ParseException {
        Calendar c = Calendar.getInstance();
        java.util.Date date = new SimpleDateFormat(pattern).parse(specifiedDay);
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - 1);
        String dayBefore = new SimpleDateFormat(pattern).format(c.getTime());
        return dayBefore;
    }

    public static Date getLastDateOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year + 1);
        calendar.set(2, 0);
        calendar.set(5, 0);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getFirstDateOfLastYear(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, -1);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getLastDateOfLastYear(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 0);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static java.util.Date addDays(java.util.Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static int getSecond(java.util.Date date) {
        CommonUtil.verification(date != null, "getYear\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static Date getFirstDateOfMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getLastDateOfMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 0);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getFirstDateOfLastMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(5, 1);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getLastDateOfLastMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        int lastDay = calendar.getActualMaximum(5);
        calendar.set(5, lastDay);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getFirstDateOfWeek(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getLastDateOfWeek(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 7);
        calendar.add(5, 1);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getFirstDateOfLastWeek(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        Date firstDayOfWeek = CommonUtil.getFirstDateOfWeek(date);
        calendar.setTime(firstDayOfWeek);
        calendar.add(5, -7);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static Date getLastDateOfLastWeek(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        Date lastDayOfWeek = CommonUtil.getFirstDateOfWeek(date);
        calendar.setTime(lastDayOfWeek);
        calendar.add(5, -1);
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()));
    }

    public static int getDayOfWeek(java.util.Date date) {
        Calendar localCalendar = Calendar.getInstance();
        localCalendar.setTime(date);
        return localCalendar.get(7);
    }

    public static Date getStepDay(java.util.Date date, int step) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, step);
        return new Date(calendar.getTime().getTime());
    }

    public static Integer getDaysBetween(java.util.Date start, java.util.Date end) {
        Assert.notNull((Object)start, (String)"\u53c2\u6570start\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.notNull((Object)end, (String)"\u53c2\u6570end\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Long result = (end.getTime() - start.getTime()) / 86400000L;
        return result.intValue();
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((java.util.Date)obj);
        }
        if (obj instanceof Time) {
            return new SimpleDateFormat("HH:mm:ss").format((java.util.Date)obj);
        }
        if (obj instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd").format((java.util.Date)obj);
        }
        if (obj instanceof BigDecimal) {
            return new DecimalFormat("#.##################################").format(obj);
        }
        return obj.toString();
    }

    public static int toInteger(Object obj) {
        CommonUtil.verification(obj != null, "toInteger\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        if (obj instanceof String) {
            return Integer.valueOf((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        throw new RuntimeException("\u9519\u8bef\u7684toInteger\u53c2\u6570\u7c7b\u578b\uff1a" + obj.getClass());
    }

    public static BigDecimal toDecimal(Object obj) {
        CommonUtil.verification(obj != null, "toDecimal\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        BigDecimal result = null;
        if (obj instanceof String) {
            result = BigDecimal.valueOf(Double.valueOf((String)obj));
        } else if (obj instanceof Number) {
            result = BigDecimal.valueOf(((Number)obj).doubleValue());
        } else {
            throw new RuntimeException("\u9519\u8bef\u7684toDecimal\u53c2\u6570\u7c7b\u578b\uff1a" + obj.getClass());
        }
        result.setScale(20, RoundingMode.HALF_UP);
        return result;
    }

    public static long toLong(Object obj) {
        CommonUtil.verification(obj != null, "toLong\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        if (obj instanceof String) {
            return Long.valueOf((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        throw new RuntimeException("\u9519\u8bef\u7684toLong\u53c2\u6570\u7c7b\u578b\uff1a" + obj.getClass());
    }

    public static double toDouble(Object obj) {
        CommonUtil.verification(obj != null, "toDouble\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        if (obj instanceof String) {
            return Double.valueOf((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        throw new RuntimeException("\u9519\u8bef\u7684toDouble\u53c2\u6570\u7c7b\u578b\uff1a" + obj.getClass());
    }

    public static float toFloat(Object obj) {
        CommonUtil.verification(obj != null, "toFloat\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        if (obj instanceof String) {
            return Float.valueOf((String)obj).floatValue();
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        throw new RuntimeException("\u9519\u8bef\u7684toFloat\u53c2\u6570\u7c7b\u578b\uff1a" + obj.getClass());
    }

    public static Float roundTo(Float value, int digit) {
        BigDecimal b = new BigDecimal(value.floatValue());
        return Float.valueOf(b.setScale(digit, 4).floatValue());
    }

    public static Date toDate(Object obj) {
        CommonUtil.verification(obj != null, "toDate\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof String) {
            return Date.valueOf((String)obj);
        }
        if (obj instanceof java.util.Date) {
            return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format((java.util.Date)obj));
        }
        throw new RuntimeException("\u9519\u8bef\u7684toDate\u53c2\u6570\u7c7b\u578b\uff1a" + obj.getClass());
    }

    public static Timestamp toDateTime(Object obj) {
        CommonUtil.verification(obj != null, "toDateTime\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof String) {
            try {
                return new Timestamp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String)obj).getTime());
            }
            catch (Exception localException) {
                throw new RuntimeException("\u5c06\u5b57\u7b26\u4e32\uff1a" + obj + "\u8f6c\u6362\u4e3aDATETIME\u65f6\u51fa\u9519\uff01");
            }
        }
        if (obj instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)obj).getTime());
        }
        throw new RuntimeException("\u9519\u8bef\u7684toDateTime\u53c2\u6570\u7c7b\u578b\uff1a" + obj.getClass());
    }

    public static Time toTime(Object obj) {
        CommonUtil.verification(obj != null, "toTime\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        if (obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof String) {
            return Time.valueOf((String)obj);
        }
        if (obj instanceof java.util.Date) {
            return Time.valueOf(new SimpleDateFormat("HH:mm:ss").format((java.util.Date)obj));
        }
        throw new RuntimeException("\u9519\u8bef\u7684toTime\u53c2\u6570\u7c7b\u578b\uff1a" + obj.getClass());
    }

    public static String toChineseNumber(Number value, boolean isCapital) {
        CommonUtil.verification(value != null, "toChineseNumber\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        CommonUtil.verification(isCapital, "\u76ee\u524d\u4e0d\u652f\u6301\u8f6c\u6362\u4e3a\u5c0f\u5199\u7684\u6c49\u5b57\u6570\u5b57\uff01");
        if (value instanceof BigDecimal) {
            return NumberUtil.formatString((BigDecimal)value);
        }
        return NumberUtil.formatString(value.doubleValue());
    }

    public static String toChineseMoney(Number value) {
        CommonUtil.verification(value != null, "toChineseMoney\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        String s = null;
        s = value instanceof BigDecimal ? NumberUtil.formatString((BigDecimal)value) : NumberUtil.formatString(value.doubleValue());
        return NumberUtil.toMoeny(s);
    }

    public static String ltrim(String value) {
        int i;
        if (value == null) {
            return null;
        }
        if ("".equals(value)) {
            return "";
        }
        for (i = 0; i < value.length() && value.charAt(i) <= ' '; ++i) {
        }
        return value.substring(i);
    }

    public static String rtrim(String value) {
        int i;
        if (value == null) {
            return null;
        }
        if ("".equals(value)) {
            return "";
        }
        for (i = value.length(); i > 0 && value.charAt(i - 1) <= ' '; --i) {
        }
        return value.substring(0, i);
    }

    public static String lpad(int length, int number) {
        String f = "%0" + length + "d";
        return String.format(f, number);
    }

    public static String getExtOfFile(String path) {
        String str = CommonUtil.getNameOfFile(path);
        if (str == null || "".equals(str)) {
            return null;
        }
        return str.indexOf(46) != -1 ? str.substring(str.lastIndexOf(46) + 1, str.length()) : null;
    }

    public static String getPathOfFile(String path) {
        if (path == null || "".equals(path)) {
            return null;
        }
        if ((path = path.trim()).indexOf(47) == -1) {
            return null;
        }
        return path.substring(0, path.lastIndexOf(47));
    }

    public static String getNameOfFile(String path) {
        if (path == null || "".equals(path)) {
            return null;
        }
        if ((path = path.trim()).indexOf(47) == -1) {
            return path;
        }
        return path.substring(path.lastIndexOf(47) + 1, path.length());
    }

    public static String getNameNoExtOfFile(String path) {
        String fileName = CommonUtil.getNameOfFile(path);
        if (fileName == null || "".equals(fileName)) {
            return fileName;
        }
        return fileName.indexOf(46) != -1 ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
    }

    private static void verification(boolean isOK, String message) {
        if (!isOK) {
            RuntimeException ex = new RuntimeException(message);
            throw ex;
        }
    }

    public static boolean isLongNull(Long value) {
        return value == null || value.intValue() == 0;
    }

    public static boolean isIntegerNull(Integer value) {
        return value == null || value == 0;
    }

    public static String getFileName(String fileName) {
        int pos;
        int unixSep = fileName.lastIndexOf(47);
        int winSep = fileName.lastIndexOf(92);
        int n = pos = winSep > unixSep ? winSep : unixSep;
        if (pos != -1) {
            fileName = fileName.substring(pos + 1);
        }
        fileName = fileName.replace("=", "").replace(",", "").replace("&", "");
        return fileName;
    }

    public static List<String> getExpressionKey(String expressionStr) {
        if (StringUtils.isEmpty((Object)expressionStr)) {
            return Lists.newArrayList();
        }
        String[] split = expressionStr.split("[^\\w\\d]+");
        if (split.length < 1) {
            return Lists.newArrayList();
        }
        List<String> keyList = Arrays.asList(split);
        return keyList;
    }

    public static String replaceExpression(List<String> keyList, String expressionStr, Map<String, BigDecimal> map) {
        if (CollectionUtils.isEmpty(keyList) || StringUtils.isEmpty((Object)expressionStr)) {
            return null;
        }
        for (String str : keyList) {
            if (!map.containsKey(str)) continue;
            expressionStr = expressionStr.replaceAll(str, map.get(str).toString());
        }
        return expressionStr;
    }

    public static BigDecimal convertToCode(String expressionStr, Map<String, BigDecimal> map, int margin) {
        if (StringUtils.isEmpty((Object)expressionStr)) {
            return null;
        }
        JexlEngine jexlEngine = new JexlEngine();
        Expression expression = jexlEngine.createExpression(expressionStr);
        MapContext jexlContext = new MapContext();
        jexlContext.set("Math", Math.class);
        jexlContext.set("BigDecimal", BigDecimal.class);
        for (String key : map.keySet()) {
            BigDecimal p = map.get(key);
            if (null == p) continue;
            Double val = 0.0;
            if (p instanceof BigDecimal) {
                BigDecimal temp = p;
                val = temp.doubleValue();
            } else if (cn.hutool.core.util.NumberUtil.isNumber((CharSequence)((Object)p).toString())) {
                val = Double.valueOf(((Object)p).toString());
            }
            jexlContext.set(key, (Object)val);
        }
        Object evaluate = expression.evaluate((JexlContext)jexlContext);
        BigDecimal result = new BigDecimal(null == evaluate ? "0" : evaluate.toString());
        return result.setScale(margin, 4);
    }

    public static void main(String[] args) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("CF1000", new BigDecimal("10"));
        map.put("CF2000", new BigDecimal("3"));
        String expressionStr = "CF1000+CF2000+CF3000";
        List<String> expressionKey = CommonUtil.getExpressionKey(expressionStr);
        System.out.println(CommonUtil.replaceExpression(expressionKey, expressionStr, map));
        if (map.size() == expressionKey.size()) {
            System.out.println(CommonUtil.convertToCode(CommonUtil.replaceExpression(expressionKey, expressionStr, map), map, 2));
        }
    }

    static class NumberUtil {
        private static String[] quantity = new String[]{"", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf"};
        private static String[] bigNumber = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        private static int c = 4;
        private static int d = 8;
        private static int e = 1;
        private static int f = 2;
        private static int g = 4;
        private static int h = 8;

        NumberUtil() {
        }

        public static String formatString(double paramDouble) {
            return NumberUtil.formatString(new DecimalFormat("#.##################################").format(paramDouble));
        }

        public static String formatString(int value) {
            return NumberUtil.formatString(String.valueOf(value));
        }

        public static String formatString(BigDecimal value) {
            return NumberUtil.formatString(new DecimalFormat("#.##################################").format(value));
        }

        public static String formatString(String value) {
            String[] valueArray;
            if (value == null || "".equals(value)) {
                return null;
            }
            Double.valueOf(value);
            StringBuffer sb = new StringBuffer();
            if (value.charAt(0) == '-') {
                sb.append("\u8d1f");
                value = value.substring(1);
            }
            if ((valueArray = value.split("[.]")).length > 2 || valueArray.length < 1) {
                throw new RuntimeException("\u975e\u6cd5\u7684\u6570\u503c\u683c\u5f0f\uff1a" + value);
            }
            sb.append(NumberUtil.smallToBig(valueArray[0]));
            if (valueArray.length == 2) {
                sb.append("\u70b9");
                for (char k : valueArray[1].toCharArray()) {
                    sb.append(bigNumber[k - 48]);
                }
            }
            return sb.toString();
        }

        private static String smallToBig(String value) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (int j = 0; j < value.length(); ++j) {
                int k = value.length() - j - 1;
                String str = quantity[k];
                int m = value.charAt(j) - 48;
                if (m == 0) {
                    if (str.equals("\u4ebf") && (i & g) > 0 || str.equals("\u4e07") && (i & f) > 0) {
                        sb.append(str);
                    }
                    if ((i & h) == 0 && j == value.length() - 1) {
                        sb.append(bigNumber[m]);
                    }
                    i |= e;
                    continue;
                }
                if ((i & e) > 0 && (i & h) > 0) {
                    sb.append("\u96f6");
                }
                if (k >= d) {
                    i |= g;
                } else if (k >= c) {
                    i |= f;
                }
                i &= ~e;
                sb.append(bigNumber[m]);
                sb.append(str);
                i |= h;
            }
            return sb.toString();
        }

        public static String toMoeny(String value) {
            if (value.indexOf(28857) >= 0) {
                String[] valueArray = value.split("\u70b9");
                StringBuffer sb = new StringBuffer(valueArray[0]);
                sb.append("\u5143");
                sb.append(valueArray[1].charAt(0));
                sb.append("\u89d2");
                if (valueArray[1].length() == 2) {
                    sb.append(valueArray[1].charAt(1));
                    sb.append("\u5206");
                }
                return sb.toString();
            }
            return value + "\u5143\u6574";
        }
    }
}

