package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 投资--萨固密集团产能分布情况数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-27
 */
@Data
@ApiModel(value="QfInvestProductivityD对象", description="投资--萨固密集团产能分布情况数据填报详情表")
public class QfInvestProductivityD extends BaseModel<QfInvestProductivityD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报年")
    @TableField(exist = false)
    private Integer fillYear;

    @ApiModelProperty(value = "填报季度")
    @TableField(exist = false)
    private Integer fillQuarter;

    @ApiModelProperty(value = "填报月")
    @TableField(exist = false)
    private Integer fillMonth;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "公司编码", column = "B")
    @ApiModelProperty(value = "所属企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属企业名称")
    @Excel(name = "（生成线）公司", column = "A")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @ApiModelProperty(value = "所属企业英文名称")
    @TableField("enterprise_name_en_")
    private String enterpriseNameEn;

    @Excel(name = "密炼产线条数", column = "C")
    @ApiModelProperty(value = "密炼产线条数")
    @TableField("banburying_num_")
    private BigDecimal banburyingNum;

    @Excel(name = "密炼每条线年产能（万吨）", column = "D")
    @ApiModelProperty(value = "密炼每条线年产能（万吨）")
    @TableField("banburying_capacity_")
    private BigDecimal banburyingCapacity;

    @Excel(name = "密炼线总产能（万吨）", column = "E")
    @ApiModelProperty(value = "密炼线总产能（万吨）")
    @TableField("banburying_capacity_total_")
    private BigDecimal banburyingCapacityTotal;

    @Excel(name = "EPDM挤出线数", column = "F")
    @ApiModelProperty(value = "EPDM挤出线数")
    @TableField("epdm_num_")
    private BigDecimal epdmNum;

    @Excel(name = "EPDM每条线年产能（百万米）", column = "G")
    @ApiModelProperty(value = "EPDM每条线年产能（百万米）")
    @TableField("epdm_capacity_")
    private BigDecimal epdmCapacity;

    @Excel(name = "EPDM挤出线总产能（百万米）", column = "H")
    @ApiModelProperty(value = "EPDM挤出线总产能（百万米）")
    @TableField("epdm_capacity_total_")
    private BigDecimal epdmCapacityTotal;

    @Excel(name = "TPE挤出线条数", column = "I")
    @ApiModelProperty(value = "TPE挤出线条数")
    @TableField("tpe_num_")
    private BigDecimal tpeNum;

    @Excel(name = "TPE每条线年产能（百万米）", column = "J")
    @ApiModelProperty(value = "TPE每条线年产能（百万米）")
    @TableField("tpe_capacity_")
    private BigDecimal tpeCapacity;

    @Excel(name = "TPE挤出线总产能（百万米）", column = "K")
    @ApiModelProperty(value = "TPE挤出线总产能（百万米）")
    @TableField("tpe_capacity_total_")
    private BigDecimal tpeCapacityTotal;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
