package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfReportSubjectDao;
import com.artfess.cqlt.manager.QfReportSubjectManager;
import com.artfess.cqlt.model.QfReportSubject;
import com.artfess.cqlt.model.QfSubjectInfo;
import com.artfess.cqlt.model.QfSubjectRelation;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 报表填报科目 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-02-17
 */
@Service
public class QfReportSubjectManagerImpl extends BaseManagerImpl<QfReportSubjectDao, QfReportSubject> implements QfReportSubjectManager {

    @Override
    public List<QfSubjectInfo> getSubjectInfo(String reportId) {
        return this.baseMapper.getSubjectInfo(reportId);
    }

    @Override
    public List<QfSubjectRelation> getRelationList(String reportId) {
        return this.baseMapper.getRelationList(reportId);
    }
}
