package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.cqlt.dao.QfReportRangeDao;
import com.artfess.cqlt.manager.QfReportRangeManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfReportRange;
import com.artfess.i18n.util.I18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 报表填报范围 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-02-17
 */
@Service
public class QfReportRangeManagerImpl extends BaseManagerImpl<QfReportRangeDao, QfReportRange> implements QfReportRangeManager {


    @Override
    public CommonResult<PageList<QfReportRange>> selectList(Integer pageNum,Integer pageSize ,String reportId) {
        PageBean pageBean = new PageBean();
        pageBean.setPage(pageNum);
        pageBean.setPageSize(pageSize);
        return new CommonResult<PageList<QfReportRange>>
                (true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()),
                        new PageList<QfReportRange>(baseMapper.selectByReportId(convert2IPage(pageBean),reportId)));
    }

    @Override
    public List<QfEnterpriseInfo> getQfEnterpriseInfo(String reportId) {
        return this.baseMapper.getQfEnterpriseInfo(reportId);
    }
}
