package com.artfess.cqlt.manager;

import com.artfess.cqlt.model.QfFinancialStatistical;
import com.artfess.base.manager.BaseManager;
import com.artfess.cqlt.vo.DataInfoVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.ReportVo;
import com.artfess.cqlt.vo.ReportReqVo;

import java.math.BigDecimal;
import java.util.List;

/**
 * 财务主题大屏统计宽表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
public interface QfFinancialStatisticalManager extends BaseManager<QfFinancialStatistical> {

    /**
     * 根据上报的数据
     * @param list 当前上报数据
     * @param dataInfoVo 上报时间信息
     * @param dataType 上报数据类型 1：实际值，2：预算值
     * @return
     */
    boolean saveData(List<ReportVo> list, DataInfoVo dataInfoVo, Integer dataType);

    List<FaTargetRespVo> data(ReportReqVo t);

    List<FaTargetRespVo> fromUnderData(ReportReqVo t);
    /**
     * 数据分析接口
     * @param t
     * @return
     */
    List<FaTargetRespVo> dataAnalysis(ReportReqVo t);

    BigDecimal getLastYearSales(int lastYear, String salesCode, String code);

    BigDecimal getlastYearProfitsSales(int lastYear, String profitsSalesCode, String code);

    /**
     * 资金1级指标
     * @param t
     * @return
     */
    List<FaTargetRespVo> moneyData(ReportReqVo t);

    List<FaTargetRespVo> bridgeFigureAnalysis(ReportReqVo t);
}
