/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfEuroRatesDDao;
import com.artfess.cqlt.dao.QfEuroRatesMDao;
import com.artfess.cqlt.manager.QfEuroRatesDManager;
import com.artfess.cqlt.model.QfEuroRatesD;
import com.artfess.cqlt.model.QfEuroRatesM;
import com.artfess.cqlt.vo.EuroRatesRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.CustomHeader;
import com.artfess.poi.util.HeaderNode;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfEuroRatesDManagerImpl
extends BaseManagerImpl<QfEuroRatesDDao, QfEuroRatesD>
implements QfEuroRatesDManager {
    @Resource
    private QfEuroRatesMDao ratesMDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfEuroRatesM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfEuroRatesM euroRatesM = (QfEuroRatesM)((Object)this.ratesMDao.selectById((Serializable)((Object)t.getId())));
        List<QfEuroRatesD> list = t.getList();
        list.forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setFillDate(euroRatesM.getFillDate());
        });
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }

    @Override
    public List<JSONObject> detailQuery(List<QfEuroRatesD> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        String mainId = list.get(0).getMainId();
        ArrayList detailList = Lists.newArrayList();
        List<String> monthList = ((QfEuroRatesDDao)this.baseMapper).getMonthList(mainId);
        JSONObject detail = new JSONObject(true);
        detail.put("type", (Object)"");
        monthList.forEach(month -> detail.put(month + "\u6708", (Object)(month + "\u6708")));
        detailList.add(detail);
        Map<String, List<QfEuroRatesD>> collect = list.stream().collect(Collectors.groupingBy(QfEuroRatesD::getType));
        collect.forEach((type, v) -> {
            JSONObject data = new JSONObject(true);
            data.put("type", type);
            for (QfEuroRatesD pld : v) {
                data.put(pld.getMonth() + "\u6708", (Object)(pld.getFillData() + "%"));
            }
            detailList.add(data);
        });
        return detailList;
    }

    @Override
    public List<EuroRatesRespVo> euroRatesAnalysis(ReportReqVo t) {
        return ((QfEuroRatesDDao)this.baseMapper).euroRatesAnalysis(t);
    }

    @Override
    public void export(HttpServletRequest request, HttpServletResponse response, List<QfEuroRatesD> list, String sheetName) throws IOException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String mainId = list.get(0).getMainId();
        List<String> monthList = ((QfEuroRatesDDao)this.baseMapper).getMonthList(mainId);
        HashMap rowMap = Maps.newHashMap();
        HashMap columMap = Maps.newHashMap();
        ArrayList headerNodeList = Lists.newArrayList();
        HeaderNode headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(0);
        headerNode.setHeaderName("");
        headerNodeList.add(headerNode);
        Integer column = 1;
        Integer row = 1;
        for (String string : monthList) {
            headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(column.intValue());
            headerNode.setHeaderName(string + "\u6708");
            headerNodeList.add(headerNode);
            columMap.put(string, headerNode.getColumn());
            Integer n = column;
            Integer n2 = column = Integer.valueOf(column + 1);
        }
        Map<String, List<QfEuroRatesD>> collect = list.stream().collect(Collectors.groupingBy(QfEuroRatesD::getType));
        for (Map.Entry<String, List<QfEuroRatesD>> entry : collect.entrySet()) {
            String type = entry.getKey();
            headerNode = new HeaderNode();
            headerNode.setRow(row.intValue());
            headerNode.setColumn(0);
            headerNode.setHeaderName(type);
            headerNodeList.add(headerNode);
            rowMap.put(type, headerNode.getRow());
            Integer n = row;
            Integer n3 = row = Integer.valueOf(row + 1);
        }
        for (Map.Entry<String, List<QfEuroRatesD>> entry : collect.entrySet()) {
            List<QfEuroRatesD> value = entry.getValue();
            value.forEach(detail -> {
                HeaderNode node = new HeaderNode();
                node.setRow(((Integer)rowMap.get(detail.getType())).intValue());
                node.setColumn(((Integer)columMap.get(detail.getMonth())).intValue());
                node.setHeaderName(detail.getFillData().toString());
                headerNodeList.add(node);
            });
        }
        String string = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String fileName = String.format(sheetName + "-%s", string);
        CustomHeader.export((List)headerNodeList, (HttpServletResponse)response, (String)fileName, (String)sheetName);
    }
}

