/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.OperationTargetTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationCipDDao;
import com.artfess.cqlt.dao.QfOperationCipMDao;
import com.artfess.cqlt.dao.QfSubjectInternationalInfoDao;
import com.artfess.cqlt.manager.QfOperationCipDManager;
import com.artfess.cqlt.model.QfOperationCipD;
import com.artfess.cqlt.model.QfOperationCipM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.utils.FinancialTimeUtils;
import com.artfess.cqlt.vo.OpDateReqVo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.artfess.cqlt.vo.OpReportRespVo;
import com.artfess.cqlt.vo.OpTargetRespVo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class QfOperationCipDManagerImpl
extends BaseManagerImpl<QfOperationCipDDao, QfOperationCipD>
implements QfOperationCipDManager {
    private FinancialTimeUtils financialTimeUtils = new FinancialTimeUtils();
    @Resource
    private QfOperationCipMDao cipMDao;
    @Resource
    private QfSubjectInternationalInfoDao subjectInternationalInfoDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchSave(QfOperationCipM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfOperationCipM qfOperationCipM = (QfOperationCipM)((Object)this.cipMDao.selectById((Serializable)((Object)t.getId())));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List qfSubjectInternationalInfos = this.subjectInternationalInfoDao.selectList((Wrapper)query);
        Map<String, QfSubjectInternationalInfo> detailMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        List<QfOperationCipD> list = t.getList();
        StringBuffer sb = new StringBuffer();
        list.forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setFillDate(qfOperationCipM.getFillDate());
            if (StringUtils.isEmpty((Object)detail.getSubjectCode())) {
                throw new BaseException(I18nUtil.getMessage((String)"fill.code", (Locale)LocaleContextHolder.getLocale()));
            }
            if (!detailMap.containsKey(detail.getSubjectCode())) {
                sb.append(",");
                sb.append(detail.getSubjectCode());
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)detailMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
            }
        });
        if (sb.length() > 0) {
            throw new BaseException(sb.substring(1) + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }

    @Override
    public List<OpReportRespVo> yearData(OpReportReqVo t) {
        return ((QfOperationCipDDao)this.baseMapper).yearData(t);
    }

    @Override
    public List<OpTargetRespVo> dataAnalysis(OpReportReqVo t, SysSubjectTarget target) {
        List<String> typeList = Arrays.asList(target.getType().split(","));
        ArrayList resultList = Lists.newArrayList();
        typeList.forEach(type -> {
            OperationTargetTypeEnum targetTypeEnum = OperationTargetTypeEnum.getTarget((String)type);
            if (null == targetTypeEnum) {
                return;
            }
            OpDateReqVo dateReqVo = this.financialTimeUtils.processOpDateReqVo(t, (String)type);
            this.financialTimeUtils.processOpDateQuery(t, dateReqVo);
            switch (targetTypeEnum) {
                case ndsj: {
                    t.setYear(null);
                    this.yearAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndlbsy: {
                    this.yearAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndlb: {
                    this.yearSubjectProportion(target, t, resultList, targetTypeEnum);
                    break;
                }
                case dysj: {
                    this.monthAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
            }
        });
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfOperationCipM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfOperationCipM qfOperationCipM = (QfOperationCipM)((Object)this.cipMDao.selectById((Serializable)((Object)t.getId())));
        Assert.notNull((Object)((Object)qfOperationCipM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(qfOperationCipM.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List qfSubjectInternationalInfos = this.subjectInternationalInfoDao.selectList((Wrapper)query);
        Map<String, QfSubjectInternationalInfo> detailMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        List<QfOperationCipD> list = t.getList();
        StringBuffer sb = new StringBuffer();
        list.forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setFillDate(qfOperationCipM.getFillDate());
            if (StringUtils.isEmpty((Object)detail.getSubjectCode())) {
                throw new BaseException(I18nUtil.getMessage((String)"fill.code", (Locale)LocaleContextHolder.getLocale()));
            }
            if (!detailMap.containsKey(detail.getSubjectCode())) {
                sb.append(",");
                sb.append(detail.getSubjectCode());
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)detailMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
            }
        });
        if (sb.length() > 0) {
            throw new BaseException(sb.substring(1) + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }

    private void yearAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationCipDDao)this.baseMapper).yearData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearSubjectProportion(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationCipDDao)this.baseMapper).yearSubjectData(t);
        BigDecimal totalActual = opReportRespVos.stream().map(OpReportRespVo::getActual).reduce(BigDecimal.ZERO, BigDecimal::add);
        opReportRespVos.stream().forEach(resp -> {
            BigDecimal actual = BigDecimal.ZERO;
            if (null != resp.getActual() && 0.0 != resp.getActual().doubleValue()) {
                actual = resp.getActual().divide(totalActual, 4, 4).multiply(new BigDecimal(100));
            }
            resp.setActual(actual);
            resp.setBudget(null);
        });
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void monthAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationCipDDao)this.baseMapper).monthAnalysis(t);
        opReportRespVos.forEach(resp -> resp.setYear(t.getYear()));
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private OpTargetRespVo getOpTargetRespVo(SysSubjectTarget target, OperationTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        OpTargetRespVo resultFa = new OpTargetRespVo();
        resultFa.setTargetId(target.getId());
        resultFa.setTargetName(targetTypeEnum.getTargetName());
        resultFa.setTargetNameEn(targetTypeEnum.getTargetNameEn());
        resultFa.setTargetUnit(target.getUnit());
        resultFa.setType(type);
        resultFa.setSn(targetTypeEnum.getType());
        resultFa.setStaLat(targetTypeEnum.getStaLat());
        return resultFa;
    }
}

