/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfInvestProductivityMDao;
import com.artfess.cqlt.manager.QfInvestProductivityDManager;
import com.artfess.cqlt.manager.QfInvestProductivityMManager;
import com.artfess.cqlt.model.QfInvestProductivityD;
import com.artfess.cqlt.model.QfInvestProductivityM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfInvestProductivityMManagerImpl
extends BaseManagerImpl<QfInvestProductivityMDao, QfInvestProductivityM>
implements QfInvestProductivityMManager {
    @Autowired
    private QfInvestProductivityDManager investProductivityDManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfInvestProductivityD> list, String mainId) {
        QfInvestProductivityM qfOperationKpiM = (QfInvestProductivityM)((Object)((QfInvestProductivityMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)qfOperationKpiM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.investProductivityDManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> detail.setMainId(mainId));
        boolean b = this.investProductivityDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfInvestProductivityM t) {
        QfInvestProductivityM qfOperationKpiM = (QfInvestProductivityM)((Object)((QfInvestProductivityMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == qfOperationKpiM) {
            return false;
        }
        qfOperationKpiM.setStatus(qfOperationKpiM.getStatus() == 0 ? 1 : 0);
        int i = ((QfInvestProductivityMDao)this.baseMapper).updateById((Object)qfOperationKpiM);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfInvestProductivityM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List qfOperationKpiMS = ((QfInvestProductivityMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfInvestProductivityMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfInvestProductivityM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List qfOperationKpiMS = ((QfInvestProductivityMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfInvestProductivityMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }
}

