/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfEnterpriseInfoDao;
import com.artfess.cqlt.dao.QfHrPersonDDao;
import com.artfess.cqlt.dao.QfHrPersonMDao;
import com.artfess.cqlt.dao.QfSubjectInternationalInfoDao;
import com.artfess.cqlt.manager.QfHrPersonDManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfHrPersonD;
import com.artfess.cqlt.model.QfHrPersonM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.cqlt.vo.ReportDataVo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.CustomHeader;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfHrPersonDManagerImpl
extends BaseManagerImpl<QfHrPersonDDao, QfHrPersonD>
implements QfHrPersonDManager {
    @Resource
    private QfHrPersonMDao personMDao;
    @Resource
    private QfSubjectInternationalInfoDao subjectInternationalInfoDao;
    @Resource
    private QfEnterpriseInfoDao enterpriseInfoDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchSave(QfHrPersonM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfHrPersonM personM = (QfHrPersonM)((Object)this.personMDao.selectById((Serializable)((Object)t.getId())));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List qfSubjectInternationalInfos = this.subjectInternationalInfoDao.selectList((Wrapper)query);
        Map<String, QfSubjectInternationalInfo> detailMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        QueryWrapper enterpriseInfoQuery = new QueryWrapper();
        enterpriseInfoQuery.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List enterpriseInfoList = this.enterpriseInfoDao.selectList((Wrapper)enterpriseInfoQuery);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        StringBuffer sb = new StringBuffer();
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setFillDate(personM.getFillDate());
            if (StringUtils.isEmpty((Object)detail.getSubjectCode())) {
                throw new BaseException(I18nUtil.getMessage((String)"fill.code", (Locale)LocaleContextHolder.getLocale()));
            }
            if (!detailMap.containsKey(detail.getSubjectCode())) {
                sb.append(",");
                sb.append(detail.getSubjectCode());
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)detailMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
            }
            if (enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
                QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(detail.getEnterpriseCode())));
                detail.setEnterpriseName(qfEnterpriseInfo.getName());
                detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
            }
        });
        if (sb.length() > 0) {
            throw new BaseException(sb.substring(1) + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        boolean b = this.saveBatch(t.getList());
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfHrPersonM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfHrPersonM personM = (QfHrPersonM)((Object)this.personMDao.selectById((Serializable)((Object)t.getId())));
        ArrayList list = Lists.newArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List qfSubjectInternationalInfos = this.subjectInternationalInfoDao.selectList((Wrapper)query);
        Map<String, QfSubjectInternationalInfo> detailMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        QueryWrapper enterpriseInfoQuery = new QueryWrapper();
        enterpriseInfoQuery.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List enterpriseInfoList = this.enterpriseInfoDao.selectList((Wrapper)enterpriseInfoQuery);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        t.getList().forEach(detail -> {
            detail.setFillDate(personM.getFillDate());
            detail.setMainId(t.getId());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"subject_code_", (Object)detail.getSubjectCode());
            queryWrapper.eq((Object)"main_id_", (Object)t.getId());
            queryWrapper.eq((Object)"enterprise_code_", (Object)detail.getEnterpriseCode());
            QfHrPersonD qfHrPersonD = (QfHrPersonD)((Object)((Object)((QfHrPersonDDao)this.baseMapper).selectOne((Wrapper)queryWrapper)));
            if (null != qfHrPersonD) {
                qfHrPersonD.setFillData(detail.getFillData());
                list.add(qfHrPersonD);
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)detailMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
                if (enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
                    QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(detail.getEnterpriseCode())));
                    detail.setEnterpriseName(qfEnterpriseInfo.getName());
                    detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
                }
                list.add(detail);
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            return false;
        }
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }

    @Override
    public void export(HttpServletRequest request, HttpServletResponse response, List<QfHrPersonD> list, String sheetName) throws IOException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String mainId = list.get(0).getMainId();
        List<String> enterpriseCodeHeader = ((QfHrPersonDDao)this.baseMapper).getEnterpriseCodeHeader(mainId);
        List<String> subjectCodes = ((QfHrPersonDDao)this.baseMapper).getSubjectCodes(mainId);
        HashMap rowMap = Maps.newHashMap();
        AtomicReference<Integer> row = new AtomicReference<Integer>(0);
        subjectCodes.forEach(subjectCode -> {
            row.getAndSet((Integer)row.get() + 1);
            rowMap.put(subjectCode, row.get());
        });
        HashMap columMap = Maps.newHashMap();
        ArrayList headerNodeList = Lists.newArrayList();
        AtomicReference<Integer> column = new AtomicReference<Integer>(1);
        enterpriseCodeHeader.forEach(code -> {
            column.getAndSet((Integer)column.get() + 1);
            HeaderNode headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(((Integer)column.get()).intValue());
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);
            columMap.put(code, headerNode.getColumn());
        });
        HeaderNode headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(1);
        headerNode.setHeaderName("subjectCode");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(0);
        headerNode.setHeaderName("subjectName");
        headerNodeList.add(headerNode);
        list.forEach(person -> {
            HeaderNode node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(person.getSubjectCode())).intValue());
            node.setColumn(((Integer)columMap.get(person.getEnterpriseCode())).intValue());
            node.setHeaderName(person.getFillData().toString());
            headerNodeList.add(node);
            node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(person.getSubjectCode())).intValue());
            node.setColumn(0);
            String spaceStr = StringUtil.addSpace((Integer)person.getSubjectLevel());
            node.setHeaderName(spaceStr + person.getSubjectName());
            headerNodeList.add(node);
            node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(person.getSubjectCode())).intValue());
            node.setColumn(1);
            node.setHeaderName(person.getSubjectCode());
            headerNodeList.add(node);
        });
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String fileName = String.format(sheetName + "-%s", date);
        CustomHeader.export((List)headerNodeList, (HttpServletResponse)response, (String)fileName, (String)sheetName);
    }

    @Override
    public List<JSONObject> detailQuery(List<QfHrPersonD> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        String mainId = list.get(0).getMainId();
        List<String> enterpriseCodeHeader = ((QfHrPersonDDao)this.baseMapper).getEnterpriseCodeHeader(mainId);
        List<String> subjectCodes = ((QfHrPersonDDao)this.baseMapper).getSubjectCodes(mainId);
        ArrayList detailList = Lists.newArrayList();
        JSONObject detail = new JSONObject(true);
        detail.put("subjectName", (Object)"subjectName");
        detail.put("subjectCode", (Object)"subjectCode");
        detail.put("subjectUnit", (Object)"subjectUnit");
        detail.put("subjectLevel", (Object)"subjectLevel");
        enterpriseCodeHeader.forEach(code -> detail.put(code, code));
        detailList.add(detail);
        for (String subjectCode : subjectCodes) {
            JSONObject data = new JSONObject(true);
            data.put("subjectCode", (Object)subjectCode);
            for (QfHrPersonD person : list) {
                if (!person.getSubjectCode().equals(subjectCode)) continue;
                data.put("subjectName", (Object)person.getSubjectName());
                data.put("subjectUnit", (Object)person.getSubjectUnit());
                data.put("subjectLevel", (Object)person.getSubjectLevel());
                data.put(person.getEnterpriseCode(), (Object)person.getFillData());
            }
            detailList.add(data);
        }
        return detailList;
    }

    @Override
    public List<ReportDataVo> getPersonDataList(List<String> subjectCodes, Integer fillYear, Integer startMonth, Integer endMonth) {
        if (CollectionUtils.isEmpty(subjectCodes)) {
            return Lists.newArrayList();
        }
        return ((QfHrPersonDDao)this.baseMapper).getPersonDataList(subjectCodes, fillYear, startMonth, endMonth);
    }
}

