/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationSalesMDao;
import com.artfess.cqlt.manager.QfOperationSalesDManager;
import com.artfess.cqlt.manager.QfOperationSalesMManager;
import com.artfess.cqlt.model.QfOperationSalesD;
import com.artfess.cqlt.model.QfOperationSalesM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfOperationSalesMManagerImpl
extends BaseManagerImpl<QfOperationSalesMDao, QfOperationSalesM>
implements QfOperationSalesMManager {
    @Autowired
    private QfOperationSalesDManager operationSalesDManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfOperationSalesM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfOperationSalesMS = ((QfOperationSalesMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfOperationSalesMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationSalesMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfOperationSalesM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfOperationSalesMS = ((QfOperationSalesMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfOperationSalesMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationSalesMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfOperationSalesM t) {
        QfOperationSalesM QfOperationSalesM2 = (QfOperationSalesM)((Object)((QfOperationSalesMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfOperationSalesM2) {
            return false;
        }
        QfOperationSalesM2.setStatus(QfOperationSalesM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfOperationSalesMDao)this.baseMapper).updateById((Object)QfOperationSalesM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfOperationSalesD> list, String mainId) {
        QfOperationSalesM QfOperationSalesM2 = (QfOperationSalesM)((Object)((QfOperationSalesMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)QfOperationSalesM2), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.operationSalesDManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(QfOperationSalesM2.getFillDate());
        });
        boolean b = this.operationSalesDManager.saveBatch(list);
        return b;
    }
}

