/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceCfBudgetMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinanceCfBudgetDManager;
import com.artfess.cqlt.manager.QfFinanceCfBudgetMManager;
import com.artfess.cqlt.manager.QfFinanceCfBudgetSManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceCfBudgetD;
import com.artfess.cqlt.model.QfFinanceCfBudgetM;
import com.artfess.cqlt.model.QfFinanceCfBudgetS;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinanceCfBudgetMManagerImpl
extends BaseManagerImpl<QfFinanceCfBudgetMDao, QfFinanceCfBudgetM>
implements QfFinanceCfBudgetMManager {
    @Autowired
    private QfFinanceCfBudgetDManager financePlBudgetDManager;
    @Autowired
    private QfFinanceCfBudgetSManager financePlBudgetSManager;
    @Autowired
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfFinanceCfBudgetM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfFinanceCfBudgetMS = ((QfFinanceCfBudgetMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceCfBudgetMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceCfBudgetMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfFinanceCfBudgetM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfFinanceCfBudgetMS = ((QfFinanceCfBudgetMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceCfBudgetMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceCfBudgetMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfFinanceCfBudgetM t) {
        QfFinanceCfBudgetM QfFinanceCfBudgetM2 = (QfFinanceCfBudgetM)((Object)((QfFinanceCfBudgetMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfFinanceCfBudgetM2) {
            return false;
        }
        QfFinanceCfBudgetM2.setStatus(QfFinanceCfBudgetM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfFinanceCfBudgetMDao)this.baseMapper).updateById((Object)QfFinanceCfBudgetM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<HeaderNode> list, String mainId) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        QfFinanceCfBudgetM mainInfo = (QfFinanceCfBudgetM)((Object)((QfFinanceCfBudgetMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)mainInfo), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        this.removeInfo(mainId);
        Map<String, List<QfFinanceCfBudgetD>> historyMap = this.historyList(mainInfo);
        Map<String, QfSubjectInternationalInfo> subjectMap = this.subjectInternationalInfoManager.getSubjectCodeMap("CF");
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        StringBuffer sb = new StringBuffer();
        List<HeaderNode> headerNodeList = list.stream().collect(Collectors.groupingBy(HeaderNode::getRow)).get(0);
        HashMap headerMap = Maps.newHashMap();
        for (HeaderNode headerNode : headerNodeList) {
            headerMap.put(headerNode.getColumn(), headerNode.getHeaderName());
        }
        Map<Integer, List<HeaderNode>> detailMap = list.stream().collect(Collectors.groupingBy(HeaderNode::getColumn));
        List<HeaderNode> subjectCodes = detailMap.get(1);
        HashMap subjectCodeMap = Maps.newHashMap();
        for (HeaderNode headerNode : subjectCodes) {
            subjectCodeMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        HashSet subjectCodeList = Sets.newHashSet();
        int maxColumn = detailMap.size();
        ArrayList detailList = Lists.newArrayList();
        JSONObject totalInfo = new JSONObject();
        for (Map.Entry<Integer, List<HeaderNode>> entry : detailMap.entrySet()) {
            Integer column = entry.getKey();
            List<HeaderNode> nodes = entry.getValue();
            String enterpriseCode = (String)headerMap.get(column);
            List<Object> historyDetailList = Lists.newArrayList();
            if (historyMap.containsKey(enterpriseCode)) {
                historyDetailList = historyMap.get(enterpriseCode);
            }
            for (HeaderNode node : nodes) {
                if (0 == node.getRow()) continue;
                String subjectCode = (String)subjectCodeMap.get(node.getRow());
                subjectCodeList.add(subjectCode);
                if (node.getColumn() > 1 && node.getColumn() < maxColumn - 3 && !StringUtils.isEmpty((Object)node.getHeaderName())) {
                    this.createDetail(mainId, mainInfo, subjectMap, enterpriseInfoMap, sb, subjectCodeMap, detailList, enterpriseCode, historyDetailList, node);
                    continue;
                }
                if (node.getColumn() < maxColumn - 3 || StringUtils.isEmpty((Object)node.getHeaderName())) continue;
                if (node.getColumn() == maxColumn - 1) {
                    totalInfo.put(subjectCode + ":budgetConsolidated", (Object)node.getHeaderName());
                    continue;
                }
                if (node.getColumn() == maxColumn - 2) {
                    totalInfo.put(subjectCode + ":budgetPosting", (Object)node.getHeaderName());
                    continue;
                }
                if (node.getColumn() != maxColumn - 3) continue;
                totalInfo.put(subjectCode + ":budgetTotal", (Object)node.getHeaderName());
            }
        }
        if (sb.length() > 0) {
            throw new BaseException(sb.substring(1) + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        List<QfFinanceCfBudgetS> totalList = this.getQfFinanceCfBudgetS(mainInfo, subjectMap, new ArrayList<String>(subjectCodeList), totalInfo);
        this.financePlBudgetSManager.saveBatch(totalList);
        boolean b = this.financePlBudgetDManager.saveBatch(detailList);
        return b;
    }

    private List<QfFinanceCfBudgetS> getQfFinanceCfBudgetS(QfFinanceCfBudgetM mainInfo, Map<String, QfSubjectInternationalInfo> subjectMap, List<String> subjectCodeList, JSONObject totalInfo) {
        ArrayList totalList = Lists.newArrayList();
        subjectCodeList.forEach(subjectCode -> {
            QfFinanceCfBudgetS plS = new QfFinanceCfBudgetS();
            plS.setMainId(mainInfo.getId());
            QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)subjectMap.get(subjectCode)));
            plS.setSubjectNameEn(subjectInternationalInfo.getNameEn());
            plS.setSubjectUnit(subjectInternationalInfo.getUnit());
            plS.setSubjectName(subjectInternationalInfo.getName());
            if (totalInfo.containsKey((Object)(subjectCode + ":budgetConsolidated"))) {
                plS.setBudgetConsolidated(totalInfo.getBigDecimal(subjectCode + ":budgetConsolidated"));
            }
            if (totalInfo.containsKey((Object)(subjectCode + ":budgetPosting"))) {
                plS.setBudgetPosting(totalInfo.getBigDecimal(subjectCode + ":budgetPosting"));
            }
            if (totalInfo.containsKey((Object)(subjectCode + ":budgetTotal"))) {
                plS.setBudgetTotal(totalInfo.getBigDecimal(subjectCode + ":budgetTotal"));
            }
            plS.setFillYear(mainInfo.getFillYear());
            plS.setFillMonth(mainInfo.getFillMonth());
            plS.setFillDate(mainInfo.getFillDate());
            plS.setFillQuarter(mainInfo.getFillQuarter());
            plS.setSubjectCode((String)subjectCode);
            totalList.add(plS);
        });
        return totalList;
    }

    private void createDetail(String mainId, QfFinanceCfBudgetM mainInfo, Map<String, QfSubjectInternationalInfo> subjectMap, Map<String, QfEnterpriseInfo> enterpriseInfoMap, StringBuffer sb, Map<Integer, String> subjectCodeMap, List<QfFinanceCfBudgetD> detailList, String enterpriseCode, List<QfFinanceCfBudgetD> historyDetailList, HeaderNode node) {
        QfFinanceCfBudgetD QfFinanceCfBudgetD2 = new QfFinanceCfBudgetD();
        QfFinanceCfBudgetD2.setMainId(mainId);
        QfFinanceCfBudgetD2.setFillDate(mainInfo.getFillDate());
        QfFinanceCfBudgetD2.setEnterpriseCode(enterpriseCode);
        QfFinanceCfBudgetD2.setSubjectCode(subjectCodeMap.get(node.getRow()));
        QfFinanceCfBudgetD2.setBudgetYtd(new BigDecimal(node.getHeaderName()));
        Map<String, QfFinanceCfBudgetD> historyDetailMap = historyDetailList.stream().collect(Collectors.toMap(item -> item.getSubjectCode(), item -> item));
        if (historyDetailMap.containsKey(QfFinanceCfBudgetD2.getSubjectCode())) {
            QfFinanceCfBudgetD historyDetail = historyDetailMap.get(QfFinanceCfBudgetD2.getSubjectCode());
            QfFinanceCfBudgetD2.setBudget(QfFinanceCfBudgetD2.getBudgetYtd().subtract(historyDetail.getBudgetYtd()));
        } else {
            QfFinanceCfBudgetD2.setBudget(QfFinanceCfBudgetD2.getBudgetYtd());
        }
        if (!subjectMap.containsKey(QfFinanceCfBudgetD2.getSubjectCode())) {
            sb.append(",");
            sb.append(QfFinanceCfBudgetD2.getSubjectCode());
        } else {
            QfSubjectInternationalInfo subjectInternationalInfo = subjectMap.get(QfFinanceCfBudgetD2.getSubjectCode());
            QfFinanceCfBudgetD2.setSubjectNameEn(subjectInternationalInfo.getNameEn());
            QfFinanceCfBudgetD2.setSubjectUnit(subjectInternationalInfo.getUnit());
            QfFinanceCfBudgetD2.setSubjectName(subjectInternationalInfo.getName());
            if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                QfFinanceCfBudgetD2.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
            }
        }
        if (enterpriseInfoMap.containsKey(QfFinanceCfBudgetD2.getEnterpriseCode())) {
            QfEnterpriseInfo qfEnterpriseInfo = enterpriseInfoMap.get(QfFinanceCfBudgetD2.getEnterpriseCode());
            QfFinanceCfBudgetD2.setEnterpriseName(qfEnterpriseInfo.getName());
            QfFinanceCfBudgetD2.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
        }
        detailList.add(QfFinanceCfBudgetD2);
    }

    private void removeInfo(String mainId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.financePlBudgetDManager.remove((Wrapper)queryWrapper);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_id_", (Object)mainId);
        this.financePlBudgetSManager.remove((Wrapper)query);
    }

    private Map<String, List<QfFinanceCfBudgetD>> historyList(QfFinanceCfBudgetM QfFinanceCfBudgetM2) {
        List<QfFinanceCfBudgetD> historyList = ((QfFinanceCfBudgetMDao)this.baseMapper).historyList(QfFinanceCfBudgetM2.getFillMonth() - 1, QfFinanceCfBudgetM2.getFillYear());
        if (CollectionUtils.isEmpty(historyList)) {
            return Maps.newHashMap();
        }
        return historyList.stream().collect(Collectors.groupingBy(QfFinanceCfBudgetD::getEnterpriseCode));
    }
}

