/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.listener;

import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.model.def.SubProcessStartOrEndEventModel;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.manager.impl.BpmExeStackManagerImpl;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import javax.annotation.Resource;
import org.activiti.engine.impl.entity.GatewayUnmetJoinEventModel;
import org.activiti.engine.impl.event.GatewayUnmetJoinEvent;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GatewayUnmetJoinEventListener
implements ApplicationListener<GatewayUnmetJoinEvent>,
Ordered {
    @Resource
    BpmExeStackManagerImpl bpmExeStackManager;
    @Resource
    NatTaskService natTaskService;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(GatewayUnmetJoinEvent ev) {
        GatewayUnmetJoinEventModel eventModel = (GatewayUnmetJoinEventModel)ev.getSource();
        String nodeId = eventModel.getActivity().getId();
        String nodeName = eventModel.getActivityExecution().getCurrentActivityName();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        DefaultBpmTask bpmTask = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
        if (bpmTask == null) {
            return;
        }
        if (eventModel.getFlag() != null && eventModel.getFlag().equals("ParallelMultiInstanceEnd")) {
            SubProcessStartOrEndEventModel model = (SubProcessStartOrEndEventModel)cmd.getTransitVars("SubProcessStartOrEndEventModel");
            if (model == null) {
                return;
            }
            if (model != null) {
                nodeId = model.getNodeId();
                nodeName = model.getNodeName();
            }
        }
        String oleNodeId = bpmTask.getNodeId();
        String oleNodeName = bpmTask.getName();
        bpmTask.setNodeId(nodeId);
        bpmTask.setName(nodeName);
        bpmTask.setIsGateWay(true);
        ContextThreadUtil.addTask((BpmTask)bpmTask);
        cmd.addTransitVars("CurrentEventType", (Object)"GatewayUnmetJoinEvent");
        cmd.addTransitVars("GatewayUnmetNoteType", (Object)eventModel.getNoteType());
        if (StringUtil.isNotZeroEmpty((String)bpmTask.getTaskId())) {
            BpmDelegateTask task = this.natTaskService.getByTaskId(bpmTask.getTaskId());
            try {
                this.bpmExeStackManager.pushStack(task);
            }
            catch (Exception e) {
                throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        bpmTask.setNodeId(oleNodeId);
        bpmTask.setName(oleNodeName);
    }
}

