import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加
    addData(data, cb) {
        req.post(portal + `/qf/financeSasac/company/`, data).then(res => {
            cb(res.data)
        })
    },
   
    //删除
    delDate(ids, cb) {
        req.remove(portal + `/qf/financeSasac/company/?ids=` + ids).then(res => {
            cb(res.data)
        })
    },
    //查询
    pageQuery(data, cb) {
        req.post(portal + `/qf/financeSasac/company/query`, data).then(res => {
            cb(res.data)
        })
    },

    // id查询
    detailId(id, cb) {
        req.get(portal + `/qf/financeSasac/company/` + id).then(rep => {
            cb(rep.data)
        })
    },
    //修改状态
    editStatus(data, cb) {
        req.put(portal + `/qf/financeSasac/company/updateStatus`, data).then(res => {
            cb(res.data)
        })
    },
    //导入
    importExcel(data, cb) {
        req.post(portal + `/qf/financeSasac/company/importExcel`, data).then(res => {
            cb(res.data)
        })
    },
    //导出
    export(data, cb) {
        req.post(portal + `/qf/financeSasac/company/export`, data, 'blob').then(res => {
            cb(res.data)
        })
    },
	//
	edit(data, cb) {
        req.put(portal + `/qf/financeSasac/company/`, data).then(res => {
            cb(res.data)
        })
    },
    /*二级页面*/
    //批量添加
    batchUpdateData(data, cb) {
        req.put(portal + `/qf/financeSasac/company/detail/batchUpdate`, data).then(res => {
            cb(res.data)
        })
    },
    //表格查询
    detailQuery(data, cb) {
        req.post(portal + `/qf/financeSasac/company/detail/query`, data).then(res => {
            cb(res.data)
        })
    },
    //表头表格查询
    headerDetailQuery(data, cb) {
        req.post(portal + `/qf/financeSasac/company/detailQuery`, data).then(res => {
            cb(res.data)
        })
    },
	//转换
	conversion(id, cb) {
        req.get(portal + `/qf/financeSasac/company/conversion?mainId=` + id).then(rep => {
            cb(rep.data)
        })
    },
}
