package com.artfess.application.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.application.model.MessageReceiver;
import com.artfess.application.persistence.dao.MessageReceiverDao;
import com.artfess.application.persistence.manager.MessageReadManager;
import com.artfess.application.persistence.manager.MessageReceiverManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 系统信息处理实现类
 * 
 * @company 阿特菲斯信息技术有限公司
 * @author maoww
 * @email maoww@jee-soft.cn
 * @date 2018年6月21日
 */
@Service("messageReceiverManager")
public class MessageReceiverManagerImpl extends BaseManagerImpl<MessageReceiverDao, MessageReceiver> implements MessageReceiverManager{
	@Resource
	MessageReadManager messageReadManager;
	
	@Override
	public void updateReadStatus(String[] lAryId) {
		if (lAryId.length==0) return;
		IUser currentUser = ContextUtil.getCurrentUser();
		for (String id :lAryId ){
			MessageReceiver messageReceiver = this.get(id);
			if (BeanUtils.isEmpty(messageReceiver)) continue;
			messageReadManager.addMessageRead(messageReceiver.getMsgId(),currentUser);
			
		}
	}
}
