package com.artfess.application.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.application.model.MessageRead;
import com.artfess.application.persistence.dao.MessageReadDao;
import com.artfess.application.persistence.manager.MessageReadManager;
import com.artfess.uc.api.model.IUser;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 系统信息读取处理实现类
 * 
 * @company 阿特菲斯信息技术有限公司
 * @author hugh
 * @email zxh@jee-soft.cn
 * @date 2018年6月21日
 */
@Service("messageReadManager")
public class MessageReadManagerImpl extends BaseManagerImpl<MessageReadDao, MessageRead> implements MessageReadManager{
	
	@Override
	public void addMessageRead(String msgId, IUser sysUser) {
		Map<String, Object> params = new HashMap<>();
		params.put("userId", sysUser.getUserId());
		params.put("msgId", msgId);
		MessageRead msgRead = baseMapper.getReadByUser(params);
		if(msgRead==null){
			MessageRead messageRead = new MessageRead();
			messageRead.setId(UniqueIdUtil.getSuid());
			messageRead.setMsgId(msgId);
			messageRead.setReceiverId(sysUser.getUserId());
			messageRead.setReceiver(sysUser.getFullname());
			messageRead.setReceiverTime(LocalDateTime.now());
			this.create(messageRead);
		}
		
	}
	@Override
	public List<MessageRead> getByMessageId(String messageId) {
		return baseMapper.getByMessageId(messageId);
	}
}
