package com.artfess.manage.material.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 物资采购申请
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-23
 */
@Data
@ApiModel(value = "CmgtMaterialPurchasing对象", description = "物资采购领用申请单")
@FieldRepeat(fields = {"applyTitle"},message = "申请标题已重复",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtMaterialPurchasing extends AutoFillModel<CmgtMaterialPurchasing> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "申请日期")
    @TableField("APPLICATION_DATE_")
    private LocalDate applicationDate;


    @ApiModelProperty(value = "申请人")
    @TableField("APPLICANT_")
    private String applicant;

    @ApiModelProperty(value = "申请人名称")
    @TableField("APPLICANT_name_")
    private String applicantName;

    @ApiModelProperty(value = "申请部门")
    @TableField("APPLICATION_DEPT_")
    private String applicationDept;

    @ApiModelProperty(value = "申请部门名称")
    @TableField("APPLICATION_DEPT_NAME_")
    private String applicationDeptName;

    @ApiModelProperty(value = "申请事由")
    @TableField("APPLICATION_CASE_")
    private String applicationCase;

    @ApiModelProperty(value = "审核人")
    @TableField("APPROVER_")
    private String approver;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "审核时间")
    @TableField("APPROVED_DATE_")
    private LocalDateTime approvedDate;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "状态（1：申请中 2：已确认 3：已出库）")
    @TableField("STATUS_")
    private String status;

    @TableLogic
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @TableField(exist = false)
    private List<CmgtMaterialPurchasingDetail> detailList;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;

    /** ---------------新增字段---------------------- */
    @ApiModelProperty(value = "单据号（唯一值，生成规则：YYYYMMDDXX）")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "申请类型(1:采购申请，2:领用申请)")
    @TableField("apply_type_")
    private String applyType;

    @ApiModelProperty(value = "申请标题")
    @TableField("apply_title_")
    private String applyTitle;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "需求单确认时间")
    @TableField("confirm_date_")
    private LocalDateTime confirmDate;

}
