package com.artfess.manage.dwd.manager.dto;

import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;



/**
 * dwd_sj_bus_departed
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-27
 */
@Data
@ApiModel(value="DwdSjBusDepartedDto", description="长途汽车-长途汽车历史发车DTO对象")
public class DwdSjBusDepartedDto extends ManageBaseModel<DwdSjBusDepartedDto> {


    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 发车日期 */
    @ApiModelProperty(value = "发车日期")
    private String departureDate;




    /** 班次号 */
    @ApiModelProperty(value = "班次号")
    private String shiftNumber;




    /** 线路名称 */
    @ApiModelProperty(value = "线路名称")
    private String lineName;




    /** 车牌号 */
    @ApiModelProperty(value = "车牌号")
    private String numberPlate;




    /** 席位数 */
    @ApiModelProperty(value = "席位数")
    private String seat;




    /** 发车时间 */
    @ApiModelProperty(value = "发车时间")
    private String departureTime;




    /** 出发站点 */
    @ApiModelProperty(value = "出发站点")
    private String departureSite;




    /** 已售票数 */
    @ApiModelProperty(value = "已售票数")
    private String ticketsPurchased;




    /** 已检票乘客数 */
    @ApiModelProperty(value = "已检票乘客数")
    private String checked;




    /** 执行票价 */
    @ApiModelProperty(value = "执行票价")
    private String executeFare;




    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;




    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;





    private String createByName;

}
