package com.artfess.manage.duty.model;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Optional;


/**
 *
 */
@Getter
public enum TeamMemberStatusEnum {


    CANCELLED("CANCELLED", "离职", "0"),

    NORMAL("NORMAL", "在岗", "1"),

    ONLINE("ONLINE", "在线", "2"),

    CROSSING("CROSSING", "越界", "3"),

    ABSENT("ABSENT", "缺勤", "4"),
    ;

    TeamMemberStatusEnum(String code, String desc, String type) {
        this.code = code;
        this.desc = desc;
        this.type = type;
    }

    private String code;

    private String desc;

    private String type;

    public static String findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        TeamMemberStatusEnum[] values = values();
        for (TeamMemberStatusEnum state : values) {
            if (state.getCode().equals(code)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static TeamMemberStatusEnum getByType(String val) {
        TeamMemberStatusEnum[] values = TeamMemberStatusEnum.values();
        Optional<TeamMemberStatusEnum> first = Arrays.stream(values).filter(e -> e.getCode().equals(val)).findFirst();
        return !first.isPresent() ? null : first.get();
    }

    public static String getType(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        TeamMemberStatusEnum[] values = values();
        for (TeamMemberStatusEnum state : values) {
            if (state.getCode().equals(code)) {
                return state.getType();
            }
        }
        return null;
    }
}
